/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.artifact.impl.maven;

import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;

public final class LegacySlf4jLoggerFactory
implements org.eclipse.aether.spi.log.LoggerFactory,
Service {
    public static final boolean AVAILABLE = LegacySlf4jLoggerFactory.available();
    private ILoggerFactory factory;

    private static boolean available() {
        try {
            LocationAwareLogger.class.getMethod("log", Marker.class, String.class, Integer.TYPE, String.class, Throwable.class);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public LegacySlf4jLoggerFactory() {
    }

    LegacySlf4jLoggerFactory(ILoggerFactory factory) {
        this.setLoggerFactory(factory);
    }

    public void initService(ServiceLocator locator) {
        this.setLoggerFactory((ILoggerFactory)locator.getService(ILoggerFactory.class));
    }

    public LegacySlf4jLoggerFactory setLoggerFactory(ILoggerFactory factory) {
        this.factory = factory;
        return this;
    }

    public org.eclipse.aether.spi.log.Logger getLogger(String name) {
        Logger logger = this.getFactory().getLogger(name);
        if (logger instanceof LocationAwareLogger) {
            return new Slf4jLoggerEx((LocationAwareLogger)logger);
        }
        return new Slf4jLogger(logger);
    }

    private ILoggerFactory getFactory() {
        if (this.factory == null) {
            this.factory = LoggerFactory.getILoggerFactory();
        }
        return this.factory;
    }

    private static final class Slf4jLoggerEx
    implements org.eclipse.aether.spi.log.Logger {
        private static final String FQCN = Slf4jLoggerEx.class.getName();
        private final LocationAwareLogger logger;

        public Slf4jLoggerEx(LocationAwareLogger logger) {
            this.logger = logger;
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public void debug(String msg) {
            this.logger.log(null, FQCN, 10, msg, null);
        }

        public void debug(String msg, Throwable error) {
            this.logger.log(null, FQCN, 10, msg, error);
        }

        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        public void warn(String msg) {
            this.logger.log(null, FQCN, 30, msg, null);
        }

        public void warn(String msg, Throwable error) {
            this.logger.log(null, FQCN, 30, msg, error);
        }
    }

    private static final class Slf4jLogger
    implements org.eclipse.aether.spi.log.Logger {
        private final Logger logger;

        public Slf4jLogger(Logger logger) {
            this.logger = logger;
        }

        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        public void debug(String msg) {
            this.logger.debug(msg);
        }

        public void debug(String msg, Throwable error) {
            this.logger.debug(msg, error);
        }

        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        public void warn(String msg) {
            this.logger.warn(msg);
        }

        public void warn(String msg, Throwable error) {
            this.logger.warn(msg, error);
        }
    }
}

