/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.agent.jms;

import java.net.URL;
import java.util.ServiceConfigurationError;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.xml.bind.JAXB;
import net.java.trueupdate.agent.core.ApplicationParameters;
import net.java.trueupdate.agent.core.TimerParameters;
import net.java.trueupdate.agent.core.ci.ApplicationParametersCi;
import net.java.trueupdate.agent.core.ci.TimerParametersCi;
import net.java.trueupdate.agent.jms.ci.JmsUpdateAgentParametersCi;
import net.java.trueupdate.jms.JmsParameters;
import net.java.trueupdate.jms.ci.JmsParametersCi;
import net.java.trueupdate.util.Objects;
import net.java.trueupdate.util.Resources;
import net.java.trueupdate.util.builder.AbstractBuilder;

@Immutable
public final class JmsUpdateAgentParameters {
    private static final String CONFIGURATION = "update/agent.xml";
    private final ApplicationParameters application;
    private final TimerParameters subscriptionTimer;
    private final JmsParameters messaging;

    JmsUpdateAgentParameters(Builder<?> b) {
        this.application = (ApplicationParameters)Objects.requireNonNull((Object)b.application);
        this.subscriptionTimer = null != b.subscriptionTimer ? b.subscriptionTimer : TimerParameters.builder().build();
        this.messaging = (JmsParameters)Objects.requireNonNull((Object)b.messaging);
    }

    public static JmsUpdateAgentParameters load() {
        return JmsUpdateAgentParameters.load(Resources.locate((String)CONFIGURATION));
    }

    static JmsUpdateAgentParameters load(URL source) {
        try {
            return JmsUpdateAgentParameters.parse((JmsUpdateAgentParametersCi)JAXB.unmarshal((URL)source, JmsUpdateAgentParametersCi.class));
        }
        catch (Exception ex) {
            throw new ServiceConfigurationError(String.format("Failed to load configuration from %s .", source), ex);
        }
    }

    public static JmsUpdateAgentParameters parse(JmsUpdateAgentParametersCi ci) {
        return JmsUpdateAgentParameters.builder().parse(ci).build();
    }

    public static Builder<Void> builder() {
        return new Builder<Void>();
    }

    public ApplicationParameters application() {
        return this.application;
    }

    public TimerParameters subscriptionTimer() {
        return this.subscriptionTimer;
    }

    public JmsParameters messaging() {
        return this.messaging;
    }

    public static class Builder<P>
    extends AbstractBuilder<P> {
        @CheckForNull
        ApplicationParameters application;
        @CheckForNull
        TimerParameters subscriptionTimer;
        @CheckForNull
        JmsParameters messaging;

        protected Builder() {
        }

        public final Builder<P> parse(JmsUpdateAgentParametersCi ci) {
            if (null != ci.application) {
                this.application = ApplicationParameters.parse((ApplicationParametersCi)ci.application);
            }
            if (null != ci.subscriptionTimer) {
                this.subscriptionTimer = TimerParameters.parse((TimerParametersCi)ci.subscriptionTimer);
            }
            if (null != ci.messaging) {
                this.messaging = JmsParameters.parse((JmsParametersCi)ci.messaging);
            }
            return this;
        }

        public final Builder<P> application(@Nullable ApplicationParameters applicationParameters) {
            this.application = applicationParameters;
            return this;
        }

        public final Builder<P> subscriptionTimer(@Nullable TimerParameters subscriptionTimer) {
            this.subscriptionTimer = subscriptionTimer;
            return this;
        }

        public final Builder<P> messaging(@Nullable JmsParameters messaging) {
            this.messaging = messaging;
            return this;
        }

        public final JmsUpdateAgentParameters build() {
            return new JmsUpdateAgentParameters(this);
        }
    }
}

