/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.agent.jms;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.java.trueupdate.agent.core.TimerParameters;
import net.java.trueupdate.agent.core.UpdateAgentController;
import net.java.trueupdate.agent.jms.JmsUpdateAgent;
import net.java.trueupdate.agent.jms.JmsUpdateAgentParameters;
import net.java.trueupdate.jms.JmsParameters;
import net.java.trueupdate.jms.JmsReceiver;
import net.java.trueupdate.message.UpdateMessageListener;

public final class JmsUpdateAgentController
implements UpdateAgentController {
    private final JmsUpdateAgentParameters parameters;
    private final JmsUpdateAgent agent;
    private final JmsReceiver receiver;
    private boolean started;

    public JmsUpdateAgentController() {
        this(JmsUpdateAgentParameters.load());
    }

    public JmsUpdateAgentController(JmsUpdateAgentParameters parameters) {
        this.parameters = parameters;
        this.agent = new JmsUpdateAgent(parameters);
        JmsParameters jp = parameters.messaging();
        ThreadPoolExecutor es = new ThreadPoolExecutor(0, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), JmsReceiver.LISTENER_THREAD_FACTORY);
        this.receiver = JmsReceiver.builder().connectionFactory(jp.connectionFactory()).destination(jp.fromDestination()).subscriptionName(jp.fromName()).messageSelector("manager = false").updateMessageListener((UpdateMessageListener)this.agent).executorService((ExecutorService)es).build();
    }

    public void start() {
        if (this.started) {
            return;
        }
        TimerParameters tp = this.parameters.subscriptionTimer();
        long delay = tp.unit().toMillis(tp.delay());
        if (0L < delay) {
            new Timer("TrueUpdate Agent JMS / Subscription Timer", true).schedule((TimerTask)new Start(), delay);
        } else {
            this.startWrapped();
        }
        this.started = true;
    }

    private void startWrapped() {
        try {
            this.startNow();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to start the update agent.", ex);
        }
    }

    private void startNow() throws Exception {
        new Thread((Runnable)this.receiver, "TrueUpdate Agent JMS / Receiver").start();
        this.agent.subscribe();
    }

    public void stop(long timeout, TimeUnit unit) {
        if (this.started) {
            this.stopWrapped(timeout, unit);
        }
    }

    private void stopWrapped(long timeout, TimeUnit unit) {
        try {
            this.stopNow(timeout, unit);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Failed to stop the update agent.", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopNow(long timeout, TimeUnit unit) throws Exception {
        try {
            this.receiver.stop(timeout, unit);
        }
        finally {
            this.agent.unsubscribe();
        }
    }

    private class Start
    extends TimerTask {
        private Start() {
        }

        @Override
        public void run() {
            try {
                JmsUpdateAgentController.this.startNow();
            }
            catch (Exception ex) {
                Logger.getLogger(JmsUpdateAgentController.class.getName()).log(Level.WARNING, "Failed to start the update agent.", ex);
            }
        }
    }
}

