/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.agent.jms;

import javax.annotation.concurrent.Immutable;
import javax.jms.ConnectionFactory;
import javax.naming.Context;
import net.java.trueupdate.agent.core.ApplicationParameters;
import net.java.trueupdate.agent.core.CoreUpdateAgent;
import net.java.trueupdate.agent.jms.JmsUpdateAgentParameters;
import net.java.trueupdate.jms.JmsParameters;
import net.java.trueupdate.jms.JmsSender;
import net.java.trueupdate.message.UpdateMessage;

@Immutable
final class JmsUpdateAgent
extends CoreUpdateAgent {
    private final ApplicationParameters applicationParameters;
    private final JmsParameters jmsParameters;
    private final JmsSender sender;

    JmsUpdateAgent(JmsUpdateAgentParameters parameters) {
        this.applicationParameters = parameters.application();
        this.jmsParameters = parameters.messaging();
        this.sender = JmsSender.create((Context)this.jmsParameters.namingContext(), (ConnectionFactory)this.jmsParameters.connectionFactory());
    }

    protected void send(UpdateMessage message) throws Exception {
        this.sender.send(message);
    }

    protected String from() {
        return this.jmsParameters.fromName();
    }

    protected String to() {
        return this.jmsParameters.toName();
    }

    protected ApplicationParameters applicationParameters() {
        return this.applicationParameters;
    }
}

