/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.agent.core;

import java.util.Locale;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import net.java.trueupdate.agent.core.ci.TimerParametersCi;
import net.java.trueupdate.util.SystemProperties;
import net.java.trueupdate.util.builder.AbstractBuilder;

@Immutable
public final class TimerParameters {
    private final long delay;
    private final TimeUnit unit;

    TimerParameters(Builder<?> b) {
        this.delay = TimerParameters.requireNonNegative(b.delay);
        if (null != b.unit) {
            this.unit = b.unit;
        } else {
            if (0L != this.delay) {
                throw new IllegalArgumentException();
            }
            this.unit = TimeUnit.MILLISECONDS;
        }
    }

    private static long requireNonNegative(long l) {
        if (0L > l) {
            throw new IllegalArgumentException();
        }
        return l;
    }

    public static TimerParameters parse(TimerParametersCi ci) {
        return TimerParameters.builder().parse(ci).build();
    }

    public static Builder<Void> builder() {
        return new Builder<Void>();
    }

    public long delay() {
        return this.delay;
    }

    public TimeUnit unit() {
        return this.unit;
    }

    public static class Builder<P>
    extends AbstractBuilder<P> {
        long delay;
        @CheckForNull
        TimeUnit unit;

        protected Builder() {
        }

        public final Builder<P> parse(TimerParametersCi ci) {
            if (null != ci.delay) {
                this.delay = Long.parseLong(SystemProperties.resolve((String)ci.delay, (String)"0"));
            }
            if (null != ci.unit) {
                this.unit = TimeUnit.valueOf(SystemProperties.resolve((String)ci.unit).toUpperCase(Locale.ENGLISH));
            }
            return this;
        }

        public final Builder<P> delay(long delay) {
            this.delay = delay;
            return this;
        }

        public final Builder<P> delay(TimeUnit unit) {
            this.unit = unit;
            return this;
        }

        public TimerParameters build() {
            return new TimerParameters(this);
        }
    }
}

