/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.agent.core;

import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.trueupdate.agent.core.ApplicationParameters;
import net.java.trueupdate.agent.spec.UpdateAgent;
import net.java.trueupdate.agent.spec.UpdateAgentEvent;
import net.java.trueupdate.agent.spec.UpdateAgentListener;
import net.java.trueupdate.message.UpdateMessage;
import net.java.trueupdate.message.UpdateMessageFilter;
import net.java.trueupdate.message.UpdateMessageListener;

@Immutable
public abstract class CoreUpdateAgent
extends UpdateMessageListener
implements UpdateAgent {
    private volatile UpdateMessageFilter filter;

    protected abstract ApplicationParameters applicationParameters();

    protected abstract String from();

    protected abstract String to();

    public void subscribe() throws Exception {
        this.send(UpdateMessage.Type.SUBSCRIPTION_REQUEST, null);
    }

    public void install(String version) throws Exception {
        this.send(UpdateMessage.Type.INSTALLATION_REQUEST, version);
    }

    public void proceed() throws Exception {
        this.send(UpdateMessage.Type.PROCEED_REDEPLOYMENT_RESPONSE, null);
    }

    public void cancel() throws Exception {
        this.send(UpdateMessage.Type.CANCEL_REDEPLOYMENT_RESPONSE, null);
    }

    public void unsubscribe() throws Exception {
        this.send(UpdateMessage.Type.UNSUBSCRIPTION_NOTICE, null);
    }

    private void send(UpdateMessage.Type type, @Nullable String updateVersion) throws Exception {
        ApplicationParameters ap = this.applicationParameters();
        UpdateMessage message = UpdateMessage.builder().from(this.from()).to(this.to()).type(type).artifactDescriptor(ap.artifactDescriptor()).currentLocation(ap.currentLocation()).updateLocation(ap.updateLocation()).updateVersion(updateVersion).build();
        this.send(message);
    }

    protected abstract void send(UpdateMessage var1) throws Exception;

    protected UpdateMessageFilter filter() {
        UpdateMessageFilter f = this.filter;
        return null != f ? f : (this.filter = this.newFilter());
    }

    private UpdateMessageFilter newFilter() {
        return new UpdateMessageFilter(){
            final String currentLocation;
            {
                this.currentLocation = CoreUpdateAgent.this.applicationParameters().currentLocation();
            }

            public boolean accept(UpdateMessage message) {
                return this.currentLocation.equals(message.currentLocation());
            }
        };
    }

    protected void onSubscriptionResponse(UpdateMessage message) throws Exception {
        this.listener().onSubscriptionResponse(this.event(message));
    }

    protected void onUpdateNotice(UpdateMessage message) throws Exception {
        this.listener().onUpdateNotice(this.event(message));
    }

    protected void onProgressNotice(UpdateMessage message) throws Exception {
        this.listener().onProgressNotice(this.event(message));
    }

    protected void onRedeploymentRequest(UpdateMessage message) throws Exception {
        this.listener().onRedeploymentRequest(this.event(message));
    }

    protected void onInstallationSuccessResponse(UpdateMessage message) throws Exception {
        this.listener().onInstallationSuccessResponse(this.event(message));
    }

    protected void onInstallationFailureResponse(UpdateMessage message) throws Exception {
        this.listener().onInstallationFailureResponse(this.event(message));
    }

    private UpdateAgentListener listener() {
        return this.applicationParameters().updateAgentListener();
    }

    private UpdateAgentEvent event(final UpdateMessage message) {
        return new UpdateAgentEvent(){

            public UpdateAgent updateAgent() {
                return CoreUpdateAgent.this;
            }

            public UpdateMessage updateMessage() {
                return message;
            }
        };
    }
}

