/*
 * Decompiled with CFR 0.152.
 */
package net.java.trueupdate.agent.core;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.java.trueupdate.agent.core.ci.ApplicationParametersCi;
import net.java.trueupdate.agent.spec.UpdateAgentListener;
import net.java.trueupdate.artifact.spec.ArtifactDescriptor;
import net.java.trueupdate.artifact.spec.ci.ArtifactDescriptorCi;
import net.java.trueupdate.util.Objects;
import net.java.trueupdate.util.Strings;
import net.java.trueupdate.util.SystemProperties;
import net.java.trueupdate.util.builder.AbstractBuilder;

@Immutable
public final class ApplicationParameters {
    private final ArtifactDescriptor artifactDescriptor;
    private final String currentLocation;
    private final String updateLocation;
    private final UpdateAgentListener updateAgentListener;

    ApplicationParameters(Builder<?> b) {
        this.artifactDescriptor = (ArtifactDescriptor)Objects.requireNonNull((Object)b.artifactDescriptor);
        this.currentLocation = Strings.requireNonEmpty((String)b.currentLocation);
        this.updateLocation = Strings.nonEmptyOr((String)b.updateLocation, (String)this.currentLocation);
        this.updateAgentListener = null != b.listenerClass ? ApplicationParameters.listener(b.listenerClass) : new UpdateAgentListener();
    }

    private static UpdateAgentListener listener(String className) {
        try {
            return (UpdateAgentListener)Thread.currentThread().getContextClassLoader().loadClass(SystemProperties.resolve((String)className)).newInstance();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static ApplicationParameters parse(ApplicationParametersCi ci) {
        return ApplicationParameters.builder().parse(ci).build();
    }

    public static Builder<Void> builder() {
        return new Builder<Void>();
    }

    public UpdateAgentListener updateAgentListener() {
        return this.updateAgentListener;
    }

    public ArtifactDescriptor artifactDescriptor() {
        return this.artifactDescriptor;
    }

    public String currentLocation() {
        return this.currentLocation;
    }

    public String updateLocation() {
        return this.updateLocation;
    }

    public static class Builder<P>
    extends AbstractBuilder<P> {
        @CheckForNull
        ArtifactDescriptor artifactDescriptor;
        @CheckForNull
        String currentLocation;
        @CheckForNull
        String updateLocation;
        @CheckForNull
        String listenerClass;

        protected Builder() {
        }

        public final Builder<P> parse(ApplicationParametersCi ci) {
            if (null != ci.artifact) {
                this.artifactDescriptor = ArtifactDescriptor.parse((ArtifactDescriptorCi)ci.artifact);
            }
            this.currentLocation = SystemProperties.resolve((String)ci.currentLocation, (String)this.currentLocation);
            this.updateLocation = SystemProperties.resolve((String)ci.updateLocation, (String)this.updateLocation);
            this.listenerClass = SystemProperties.resolve((String)ci.listenerClass, (String)this.listenerClass);
            return this;
        }

        public final ArtifactDescriptor.Builder<Builder<P>> artifactDescriptor() {
            return new ArtifactDescriptor.Builder<Builder<P>>(){

                public Builder<P> inject() {
                    return Builder.this.artifactDescriptor(this.build());
                }
            };
        }

        public final Builder<P> artifactDescriptor(@Nullable ArtifactDescriptor descriptor) {
            this.artifactDescriptor = descriptor;
            return this;
        }

        public final Builder<P> currentLocation(@Nullable String location) {
            this.currentLocation = location;
            return this;
        }

        public final Builder<P> updateLocation(@Nullable String location) {
            this.updateLocation = location;
            return this;
        }

        public final Builder<P> listenerClass(@Nullable String listenerClass) {
            this.listenerClass = listenerClass;
            return this;
        }

        public final ApplicationParameters build() {
            return new ApplicationParameters(this);
        }
    }
}

