/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import net.java.truecommons.shed.BitField;
import net.java.truecommons.shed.UriDecoder;
import net.java.truecommons.shed.UriEncoder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UriCodecTest {
    private static final BitField<UriEncoder.Encoding> ENCODING_MASK = BitField.allOf(UriEncoder.Encoding.class);
    private UriEncoder encoder;
    private UriDecoder decoder;

    @Before
    public void setUp() {
        this.encoder = new UriEncoder();
        this.decoder = new UriDecoder();
    }

    @Test
    public void testNull() {
        try {
            this.encoder.encode(null, null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.encoder.encode(null, UriEncoder.Encoding.ANY);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.encoder.encode("", null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.decoder.decode(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testIllegalEncodedString() {
        for (String[] test : new String[][]{{"a%ZZ"}, {"a%ZZb"}, {"a%EF%BF"}, {"a%EF%BFb"}}) {
            try {
                this.decoder.decode(test[0]);
                Assert.fail();
            }
            catch (IllegalArgumentException ex) {
                // empty catch block
            }
        }
    }

    @Test
    public void testRoundTrip() {
        for (Object[] test : new Object[][]{{ENCODING_MASK, "\ufffd", "%EF%BF%BD"}, {ENCODING_MASK, "abcdefghijklmnopqrstuvwxyz", "abcdefghijklmnopqrstuvwxyz"}, {ENCODING_MASK, "ABCDEFGHIJKLMNOPQRSTUVWXYZ", "ABCDEFGHIJKLMNOPQRSTUVWXYZ"}, {ENCODING_MASK, "0123456789", "0123456789"}, {ENCODING_MASK, "_-!.~'()*", "_-!.~'()*"}, {ENCODING_MASK, "@", "@"}, {BitField.of((Enum)UriEncoder.Encoding.ANY, (Enum[])new UriEncoder.Encoding[]{UriEncoder.Encoding.PATH}), ":", "%3A"}, {BitField.of((Enum)UriEncoder.Encoding.AUTHORITY, (Enum[])new UriEncoder.Encoding[]{UriEncoder.Encoding.ABSOLUTE_PATH, UriEncoder.Encoding.QUERY, UriEncoder.Encoding.FRAGMENT}), ":", ":"}, {BitField.of((Enum)UriEncoder.Encoding.ANY, (Enum[])new UriEncoder.Encoding[]{UriEncoder.Encoding.AUTHORITY}), "/", "%2F"}, {BitField.of((Enum)UriEncoder.Encoding.ABSOLUTE_PATH, (Enum[])new UriEncoder.Encoding[]{UriEncoder.Encoding.PATH, UriEncoder.Encoding.QUERY, UriEncoder.Encoding.FRAGMENT}), "/", "/"}, {BitField.of((Enum)UriEncoder.Encoding.ANY, (Enum[])new UriEncoder.Encoding[]{UriEncoder.Encoding.AUTHORITY, UriEncoder.Encoding.ABSOLUTE_PATH, UriEncoder.Encoding.PATH}), "?", "%3F"}, {BitField.of((Enum)UriEncoder.Encoding.QUERY, (Enum[])new UriEncoder.Encoding[]{UriEncoder.Encoding.FRAGMENT}), "?", "?"}, {ENCODING_MASK, "#", "%23"}, {ENCODING_MASK, "%", "%25"}, {ENCODING_MASK, "%a", "%25a"}, {ENCODING_MASK, "a%", "a%25"}, {ENCODING_MASK, "%%", "%25%25"}, {ENCODING_MASK, "a%b", "a%25b"}, {ENCODING_MASK, "%a%", "%25a%25"}, {ENCODING_MASK, " ", "%20"}, {ENCODING_MASK, "\u0000", "%00"}, {ENCODING_MASK, "\u00a0", "%C2%A0"}, {ENCODING_MASK, "\u20ac", "%E2%82%AC"}, {ENCODING_MASK, "a\u20acb", "a%E2%82%ACb"}, {ENCODING_MASK, "\u20aca\u20ac", "%E2%82%ACa%E2%82%AC"}, {ENCODING_MASK, "\u00c4\u00d6\u00dc\u00df\u00e4\u00f6\u00fc", "%C3%84%C3%96%C3%9C%C3%9F%C3%A4%C3%B6%C3%BC"}, {ENCODING_MASK, "a\u00c4b\u00d6c\u00dcd\u00dfe\u00e4f\u00f6g\u00fch", "a%C3%84b%C3%96c%C3%9Cd%C3%9Fe%C3%A4f%C3%B6g%C3%BCh"}}) {
            for (UriEncoder.Encoding component : (BitField)test[0]) {
                Assert.assertEquals((Object)test[2], (Object)this.encoder.encode(test[1].toString(), component));
            }
            Assert.assertEquals((Object)test[1], (Object)this.decoder.decode(test[2].toString()));
        }
    }
}

