/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.java.truecommons.shed.Option;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class OptionNoneTest {
    private final String string;
    private final Option<String> option;

    public OptionNoneTest() {
        this.string = null;
        this.option = Option.apply((Object)this.string);
    }

    @Test
    public void testEmptyIterator() {
        Iterator it = this.option.iterator();
        Assert.assertFalse((boolean)it.hasNext());
    }

    @Test
    public void testSizeIsZero() {
        Assert.assertThat((Object)this.option.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)this.option.isEmpty());
    }

    @Test(expected=NoSuchElementException.class)
    public void testGet() {
        this.option.get();
    }

    @Test
    public void testGetOrElse() {
        Assert.assertSame((Object)this.option.getOrElse((Object)"foo"), (Object)"foo");
    }

    @Test
    public void testOrNull() {
        Assert.assertNull((Object)this.option.orNull());
    }

    @Test
    public void testEquals() {
        Option<String> o1 = this.option;
        Option o2 = Option.apply(null);
        Assert.assertEquals(o1, (Object)o2);
        Assert.assertEquals((Object)o2, o1);
        Assert.assertFalse((boolean)o1.equals((Object)Option.apply((Object)"foo")));
        Assert.assertFalse((boolean)Option.apply((Object)"foo").equals(o1));
    }
}

