/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import net.java.truecommons.shed.CanonicalStringSet;
import net.java.truecommons.shed.ExtensionSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class ExtensionSetTest {
    private ExtensionSet empty;
    private ExtensionSet[] sets;

    @Before
    public void setUp() {
        this.empty = new ExtensionSet("");
        this.sets = new ExtensionSet[]{new ExtensionSet("extension1|extension2"), new ExtensionSet("extension2|extension1"), new ExtensionSet(".extension1|.extension2"), new ExtensionSet(".extension2|.extension1"), new ExtensionSet("EXTENSION1|EXTENSION2"), new ExtensionSet("EXTENSION2|EXTENSION1"), new ExtensionSet(".EXTENSION1|.EXTENSION2"), new ExtensionSet(".EXTENSION2|.EXTENSION1"), new ExtensionSet("ExTeNsIoN1|ExTeNsIoN2"), new ExtensionSet("ExTeNsIoN2|ExTeNsIoN1"), new ExtensionSet(".eXtEnSiOn1|.eXtEnSiOn2"), new ExtensionSet(".eXtEnSiOn2|.eXtEnSiOn1"), new ExtensionSet("extension1|.extension2|extension2|.extension1"), new ExtensionSet("extension2|.extension1|extension1|.extension2"), new ExtensionSet("EXTENSION1|.EXTENSION2|EXTENSION2|.EXTENSION1"), new ExtensionSet("EXTENSION2|.EXTENSION1|EXTENSION1|.EXTENSION2"), new ExtensionSet("ExTeNsIoN1|.eXtEnSiOn2|ExTeNsIoN2|.eXtEnSiOn1"), new ExtensionSet("ExTeNsIoN2|.eXtEnSiOn1|ExTeNsIoN1|.eXtEnSiOn2"), new ExtensionSet("extension1|.extension1|EXTENSION1|.EXTENSION1|extension2|.extension2|EXTENSION2|.EXTENSION2"), new ExtensionSet("extension2|.extension2|EXTENSION2|.EXTENSION2|extension1|.extension1|EXTENSION1|.EXTENSION1"), new ExtensionSet("extension1|.extension1|EXTENSION1|.EXTENSION1|ExTeNsIoN1|.eXtEnSiOn1|extension2|.extension2|EXTENSION2|.EXTENSION2|ExTeNsIoN2|.eXtEnSiOn2"), new ExtensionSet("extension2|.extension2|EXTENSION2|.EXTENSION2|ExTeNsIoN2|.eXtEnSiOn2|extension1|.extension1|EXTENSION1|.EXTENSION1|ExTeNsIoN1|.eXtEnSiOn1"), new ExtensionSet("extension1||.extension1||EXTENSION1||.EXTENSION1||ExTeNsIoN1||.eXtEnSiOn1||extension2||.extension2||EXTENSION2||.EXTENSION2||ExTeNsIoN2||.eXtEnSiOn2"), new ExtensionSet("extension2||.extension2||EXTENSION2||.EXTENSION2||ExTeNsIoN2||.eXtEnSiOn2||extension1||.extension1||EXTENSION1||.EXTENSION1||ExTeNsIoN1||.eXtEnSiOn1")};
    }

    @Test
    public void testEqualsAndHashCode() {
        for (int i = 0; i < this.sets.length; ++i) {
            for (int j = 0; j < this.sets.length; ++j) {
                Assert.assertTrue((boolean)this.sets[i].equals((Object)this.sets[j]));
                Assert.assertEquals((long)this.sets[i].hashCode(), (long)this.sets[j].hashCode());
            }
        }
    }

    @Test
    public void testIsEmpty() {
        Assert.assertTrue((boolean)this.empty.isEmpty());
        for (ExtensionSet set : this.sets) {
            Assert.assertFalse((boolean)set.isEmpty());
        }
    }

    @Test
    public void testIteratorAndContains() {
        Assert.assertFalse((boolean)this.empty.iterator().hasNext());
        for (int i = 0; i < this.sets.length; ++i) {
            for (int j = 0; j < this.sets.length; ++j) {
                for (String s : this.sets[i]) {
                    Assert.assertTrue((boolean)this.sets[j].contains((Object)s));
                }
            }
        }
    }

    @Test
    public void testAddAll() {
        for (int i = 0; i < this.sets.length; ++i) {
            for (int j = 0; j < this.sets.length; ++j) {
                Assert.assertFalse((boolean)this.sets[i].addAll((CanonicalStringSet)this.sets[j]));
            }
        }
    }

    @Test
    public void testRetainAll() {
        for (int i = 0; i < this.sets.length; ++i) {
            for (int j = 0; j < this.sets.length; ++j) {
                Assert.assertFalse((boolean)this.sets[i].retainAll((CanonicalStringSet)this.sets[j]));
            }
        }
    }

    @Test
    public void testRemoveAll() {
        for (int i = 0; i < this.sets.length - 1; ++i) {
            ExtensionSet set = this.sets[i];
            Assert.assertFalse((boolean)set.removeAll((CanonicalStringSet)this.empty));
            Assert.assertFalse((boolean)set.isEmpty());
            Assert.assertTrue((boolean)set.removeAll((CanonicalStringSet)this.sets[i + 1]));
            Assert.assertTrue((boolean)set.isEmpty());
        }
    }

    @Test
    public void testClear() {
        for (ExtensionSet set : this.sets) {
            Assert.assertFalse((boolean)set.isEmpty());
            set.clear();
            Assert.assertTrue((boolean)set.isEmpty());
        }
    }

    @Test
    public void testToString() {
        for (ExtensionSet set : this.sets) {
            Assert.assertTrue((boolean)"extension1|extension2".equals(set.toString()));
        }
    }

    @Test
    public void testToPattern() {
        for (ExtensionSet set : this.sets) {
            Assert.assertTrue((boolean)set.toPattern().matcher(".extension1").matches());
            Assert.assertTrue((boolean)set.toPattern().matcher(".extension2").matches());
            Assert.assertTrue((boolean)set.toPattern().matcher("a.EXTENSION1").matches());
            Assert.assertTrue((boolean)set.toPattern().matcher("a.EXTENSION2").matches());
            Assert.assertTrue((boolean)set.toPattern().matcher("a.b.extension1").matches());
            Assert.assertTrue((boolean)set.toPattern().matcher("a.b.extension2").matches());
            Assert.assertTrue((boolean)set.toPattern().matcher("a.b.c.EXTENSION1").matches());
            Assert.assertTrue((boolean)set.toPattern().matcher("a.b.c.EXTENSION2").matches());
        }
    }
}

