/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import java.util.Objects;
import net.java.truecommons.shed.ExceptionBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class ExceptionBuilderTestSuite<B extends ExceptionBuilder<? super I, ? extends O>, I extends Exception, O extends Exception> {
    protected final Class<O> clazz;
    protected B builder;

    protected ExceptionBuilderTestSuite(Class<O> clazz) {
        this.clazz = Objects.requireNonNull(clazz);
    }

    protected abstract B newBuilder();

    protected abstract I newInput();

    @Before
    public void setUp() {
        this.builder = (ExceptionBuilder)Objects.requireNonNull(this.newBuilder());
    }

    @Test
    public void testCheck() throws O {
        this.builder.check();
    }

    @Test
    public void testFailThenCheck() throws O {
        try {
            this.builder.fail(null);
            Assert.fail();
        }
        catch (RuntimeException expected) {
            this.builder.check();
        }
        Assert.assertNotNull((Object)this.builder.fail(this.newInput()));
        this.builder.check();
    }

    @Test
    public void testWarnThenCheck() throws O {
        try {
            this.builder.warn(null);
            Assert.fail();
        }
        catch (RuntimeException expected) {
            this.builder.check();
        }
        try {
            this.builder.warn(this.newInput());
            this.builder.check();
            Assert.fail();
        }
        catch (Exception expected) {
            Assert.assertTrue((boolean)this.clazz.isInstance(expected));
            this.builder.check();
        }
    }
}

