/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec.spi;

import java.util.Map;
import net.java.truecommons.key.spec.KeyManager;
import net.java.truecommons.key.spec.sl.KeyManagerMapLocator;
import net.java.truecommons.key.spec.spi.KeyManagerMapFactory;
import net.java.truecommons.key.spec.spi.KeyManagerMapModifier;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class KeyManagerMapModifierTestSuite {
    protected KeyManagerMapModifier modifier;

    protected abstract Iterable<Class<?>> getClasses();

    protected abstract KeyManagerMapModifier newModifier();

    @Before
    public void before() {
        this.modifier = this.newModifier();
    }

    @Test
    public void testApply() {
        Map map = new KeyManagerMapFactory().get();
        Assert.assertThat((Object)this.modifier.apply((Object)map), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.sameInstance((Object)map)));
    }

    @Test
    public void testPriority() {
        Assert.assertTrue((this.modifier.getPriority() < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testIsLocatable() {
        Map modified = (Map)this.modifier.apply((Object)new KeyManagerMapFactory().get());
        Map located = KeyManagerMapLocator.SINGLETON.get();
        for (Class clazz : modified.keySet()) {
            Assert.assertThat(located.get(clazz), (Matcher)CoreMatchers.instanceOf(((KeyManager)modified.get(clazz)).getClass()));
        }
    }
}

