/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec.sample;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import net.java.truecommons.key.spec.KeyManager;
import net.java.truecommons.key.spec.KeyManagerMap;
import net.java.truecommons.key.spec.KeyProvider;
import net.java.truecommons.key.spec.UnknownKeyException;
import net.java.truecommons.key.spec.common.AesPbeParameters;
import net.java.truecommons.key.spec.sl.KeyManagerMapLocator;
import org.junit.Test;

public abstract class UsageTestSuite {
    KeyManagerMap getKeyManagerMap() {
        return KeyManagerMapLocator.SINGLETON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGettingAPasswordForWritingAnEncryptedFile() throws IOException, UnknownKeyException {
        KeyManager manager = this.getKeyManagerMap().manager(AesPbeParameters.class);
        File file = new File("encrypted").getCanonicalFile();
        KeyProvider provider = manager.provider(file.toURI());
        AesPbeParameters param = (AesPbeParameters)provider.getKeyForWriting();
        char[] password = param.getPassword();
        Arrays.fill(password, '\u0000');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGettingAPasswordForReadingAnEncryptedFile() throws IOException, UnknownKeyException {
        File file = new File("encrypted").getCanonicalFile();
        KeyProvider provider = this.getKeyManagerMap().manager(AesPbeParameters.class).provider(file.toURI());
        boolean invalid = false;
        do {
            AesPbeParameters param = (AesPbeParameters)provider.getKeyForReading(invalid);
            char[] password = param.getPassword();
            try {
                invalid = !"top secret".equals(new String(password));
            }
            finally {
                Arrays.fill(password, '\u0000');
            }
        } while (invalid);
    }
}

