/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec.sample;

import java.net.URI;
import net.java.truecommons.key.spec.KeyStrength;
import net.java.truecommons.key.spec.PersistentUnknownKeyException;
import net.java.truecommons.key.spec.UnknownKeyException;
import net.java.truecommons.key.spec.common.AesKeyStrength;
import net.java.truecommons.key.spec.common.AesPbeParameters;
import net.java.truecommons.key.spec.prompting.PromptingKey;

public class MyPromptingKeyView
implements PromptingKey.View<AesPbeParameters> {
    public void promptKeyForWriting(PromptingKey.Controller<AesPbeParameters> controller) throws UnknownKeyException {
        URI resource = controller.getResource();
        controller.setKeyClone((PromptingKey)this.newFakeParameters());
    }

    public void promptKeyForReading(PromptingKey.Controller<AesPbeParameters> controller, boolean invalid) throws UnknownKeyException {
        if (invalid) {
            throw new PersistentUnknownKeyException();
        }
        URI resource = controller.getResource();
        AesPbeParameters param = this.newFakeParameters();
        param.setChangeRequested(false);
        controller.setKeyClone((PromptingKey)param);
    }

    private AesPbeParameters newFakeParameters() {
        AesPbeParameters param = new AesPbeParameters();
        param.setKeyStrength((KeyStrength)AesKeyStrength.BITS_128);
        param.setPassword("top secret".toCharArray());
        return param;
    }
}

