/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec.prompting;

import java.net.URI;
import java.util.Objects;
import java.util.Random;
import javax.annotation.CheckForNull;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.key.spec.UnknownKeyException;
import net.java.truecommons.key.spec.prompting.KeyPromptingCancelledException;
import net.java.truecommons.key.spec.prompting.PromptingKey;

@ThreadSafe
public final class TestView<K extends PromptingKey<K>>
implements PromptingKey.View<K> {
    @CheckForNull
    private volatile URI resource;
    @CheckForNull
    private volatile K key;
    private volatile Action action = Action.ENTER;

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = Objects.requireNonNull(action);
    }

    @CheckForNull
    public URI getResource() {
        return this.resource;
    }

    public void setResource(@CheckForNull URI resource) {
        this.resource = resource;
    }

    @CheckForNull
    public K getKey() {
        return this.key;
    }

    public void setKey(@CheckForNull K key) {
        this.key = key;
    }

    public synchronized void promptKeyForWriting(PromptingKey.Controller<K> controller) throws UnknownKeyException {
        URI resource = this.getResource();
        if (null != resource && !resource.equals(controller.getResource())) {
            throw new IllegalArgumentException();
        }
        controller.getKeyClone();
        this.action.promptKeyForWriting(controller, this.key);
    }

    public synchronized void promptKeyForReading(PromptingKey.Controller<K> controller, boolean invalid) throws UnknownKeyException {
        URI resource = this.getResource();
        if (null != resource && !resource.equals(controller.getResource())) {
            throw new IllegalArgumentException();
        }
        try {
            controller.getKeyClone();
            throw new IllegalArgumentException();
        }
        catch (IllegalStateException expected) {
            this.action.promptKeyForReading(controller, this.key);
            return;
        }
    }

    public static enum Action {
        ENTER{

            @Override
            <K extends PromptingKey<K>> void promptKeyForWriting(PromptingKey.Controller<? super K> controller, @CheckForNull K key) throws UnknownKeyException {
                controller.setKeyClone(null);
                controller.setKeyClone(key);
            }

            @Override
            <K extends PromptingKey<K>> void promptKeyForReading(PromptingKey.Controller<? super K> controller, @CheckForNull K key) throws UnknownKeyException {
                controller.setKeyClone(null);
                controller.setKeyClone(key);
            }
        }
        ,
        CANCEL{
            private final Random rnd = new Random();

            @Override
            <K extends PromptingKey<K>> void promptKeyForWriting(PromptingKey.Controller<? super K> controller, @CheckForNull K key) throws UnknownKeyException {
                if (this.rnd.nextBoolean()) {
                    throw new KeyPromptingCancelledException();
                }
                controller.setKeyClone(null);
            }

            @Override
            <K extends PromptingKey<K>> void promptKeyForReading(PromptingKey.Controller<? super K> controller, @CheckForNull K key) throws UnknownKeyException {
                if (this.rnd.nextBoolean()) {
                    throw new KeyPromptingCancelledException();
                }
                controller.setKeyClone(null);
            }
        }
        ,
        IGNORE{

            @Override
            <K extends PromptingKey<K>> void promptKeyForWriting(PromptingKey.Controller<? super K> controller, @CheckForNull K key) throws UnknownKeyException {
            }

            @Override
            <K extends PromptingKey<K>> void promptKeyForReading(PromptingKey.Controller<? super K> controller, @CheckForNull K key) throws UnknownKeyException {
            }
        };


        abstract <K extends PromptingKey<K>> void promptKeyForWriting(PromptingKey.Controller<? super K> var1, @CheckForNull K var2) throws UnknownKeyException;

        abstract <K extends PromptingKey<K>> void promptKeyForReading(PromptingKey.Controller<? super K> var1, @CheckForNull K var2) throws UnknownKeyException;
    }
}

