/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec.prompting;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import net.java.truecommons.key.spec.UnknownKeyException;
import net.java.truecommons.key.spec.prompting.AbstractPromptingPbeParameters;
import net.java.truecommons.key.spec.prompting.PromptingKeyManager;
import net.java.truecommons.key.spec.prompting.PromptingKeyProvider;
import net.java.truecommons.key.spec.prompting.TestView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class PromptingKeyProviderTestSuite<P extends AbstractPromptingPbeParameters<P, ?>> {
    private static final URI RESOURCE = URI.create("foo");
    private static final AtomicInteger count = new AtomicInteger();
    private TestView<P> view;
    private PromptingKeyManager<P> manager;
    private PromptingKeyProvider<P> provider;

    private P createParam() {
        P param = this.newParam();
        param.setSecret((ByteBuffer)ByteBuffer.allocate(4).putInt(count.getAndIncrement()).rewind());
        return param;
    }

    protected abstract P newParam();

    @Before
    public void setUp() {
        this.view = new TestView();
        this.view.setResource(RESOURCE);
        this.manager = new PromptingKeyManager(this.view);
        this.provider = this.manager.provider(RESOURCE);
    }

    @Test
    public void testLifeCycle() throws UnknownKeyException {
        P param = this.createParam();
        this.view.setKey(param);
        Assert.assertSame(param, this.view.getKey());
        Assert.assertEquals(param, (Object)this.provider.getKeyForWriting());
        Assert.assertEquals(param, (Object)this.provider.getKeyForReading(false));
        this.view.setAction(TestView.Action.CANCEL);
        Assert.assertEquals(param, (Object)this.provider.getKeyForWriting());
        Assert.assertEquals(param, (Object)this.provider.getKeyForReading(false));
        this.provider.resetCancelledKey();
        Assert.assertEquals(param, (Object)this.provider.getKeyForReading(false));
        Assert.assertEquals(param, (Object)this.provider.getKeyForWriting());
        this.provider.resetUnconditionally();
        this.view.setKey(this.createParam());
        try {
            this.provider.getKeyForReading(false);
            Assert.fail();
        }
        catch (UnknownKeyException expected) {
            // empty catch block
        }
        this.view.setKey(this.createParam());
        try {
            this.provider.getKeyForWriting();
            Assert.fail();
        }
        catch (UnknownKeyException expected) {
            // empty catch block
        }
        this.view.setAction(TestView.Action.IGNORE);
        this.view.setKey(this.createParam());
        try {
            this.provider.getKeyForReading(false);
            Assert.fail();
        }
        catch (UnknownKeyException expected) {
            // empty catch block
        }
        this.view.setKey(this.createParam());
        try {
            this.provider.getKeyForWriting();
            Assert.fail();
        }
        catch (UnknownKeyException expected) {
            // empty catch block
        }
        this.provider.resetCancelledKey();
        this.view.setAction(TestView.Action.ENTER);
        param = this.createParam();
        param.setChangeRequested(true);
        this.view.setKey(param);
        Assert.assertEquals(param, (Object)this.provider.getKeyForReading(false));
        param = this.createParam();
        this.view.setKey(param);
        Assert.assertEquals(param, (Object)this.provider.getKeyForWriting());
        this.provider.setKey(null);
        try {
            this.provider.getKeyForReading(false);
            Assert.fail();
        }
        catch (UnknownKeyException expected) {
            // empty catch block
        }
        try {
            this.provider.getKeyForWriting();
            Assert.fail();
        }
        catch (UnknownKeyException unknownKeyException) {
            // empty catch block
        }
        param = this.createParam();
        this.provider.setKey(param);
        Assert.assertEquals(param, (Object)this.provider.getKeyForReading(false));
        this.view.setKey(this.createParam());
        Assert.assertEquals(param, (Object)this.provider.getKeyForWriting());
    }
}

