/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec;

import java.net.URI;
import java.util.Objects;
import net.java.truecommons.key.spec.KeyManager;
import net.java.truecommons.key.spec.KeyProvider;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class KeyManagerTestSuite<M extends KeyManager<?>> {
    protected M manager;

    protected abstract M newKeyManager();

    @Before
    public void before() {
        this.manager = (KeyManager)Objects.requireNonNull(this.newKeyManager());
    }

    @Test(expected=NullPointerException.class)
    public void testNoKeyProviderForNullResource() {
        this.manager.provider(null);
    }

    @Test
    public void testNonNullKeyProviderForAnyNonNullResource() {
        Assert.assertNotNull((Object)this.manager.provider(URI.create("a")));
    }

    @Test
    public void testLinkKeyProvider() {
        URI idA = URI.create("a");
        URI idB = URI.create("b");
        try {
            this.manager.link(null, null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.manager.link(idA, null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        try {
            this.manager.link(null, idB);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        this.manager.link(idA, idB);
        this.manager.unlink(idA);
        KeyProvider provA1 = this.manager.provider(idA);
        Assert.assertNotNull((Object)provA1);
        this.manager.link(idA, idB);
        this.manager.unlink(idA);
        KeyProvider provA2 = this.manager.provider(idA);
        Assert.assertNotNull((Object)provA2);
        Assert.assertNotSame((Object)provA1, (Object)provA2);
    }

    @Test
    public void testUnlinkKeyProvider() {
        URI id = URI.create("a");
        this.manager.unlink(id);
        KeyProvider prov1 = this.manager.provider(id);
        this.manager.unlink(id);
        this.manager.unlink(id);
        KeyProvider prov2 = this.manager.provider(id);
        this.manager.unlink(id);
        this.manager.unlink(id);
        Assert.assertNotSame((Object)prov1, (Object)prov2);
    }
}

