/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.key.spec;

import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import net.java.truecommons.key.spec.AbstractSecretKey;
import net.java.truecommons.shed.Buffers;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSecretKeyTestSuite<K extends AbstractSecretKey<K>> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSecretKeyTestSuite.class);
    private K key;

    protected abstract K newKey();

    @Before
    public void before() {
        this.key = this.newKey();
    }

    @Test
    public void testNoSecret() {
        Assert.assertNull((Object)this.key.getSecret());
    }

    @Test
    public void testSetKeyMakesAProtectiveCopy() {
        ByteBuffer b1 = StandardCharsets.UTF_8.encode("f\u00f6o");
        this.key.setSecret(b1);
        Assert.assertTrue((boolean)StandardCharsets.UTF_8.newEncoder().encode(CharBuffer.wrap("b\u00e4r"), b1, true).isUnderflow());
        ByteBuffer b2 = this.key.getSecret();
        Assert.assertThat((Object)b2, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)b1)));
    }

    @Test
    public void testGetKeyMakesAProtectiveCopy() {
        this.key.setSecret(StandardCharsets.UTF_8.encode("f\u00f6o"));
        ByteBuffer b1 = this.key.getSecret();
        ByteBuffer b2 = this.key.getSecret();
        Assert.assertNotSame((Object)b1, (Object)b2);
        Assert.assertEquals((Object)b1, (Object)b2);
    }

    @Test
    public void testCloneMakesAProtectiveCopyOfTheKey() {
        ByteBuffer secret = StandardCharsets.UTF_8.encode("f\u00f6o");
        this.key.setSecret(secret);
        AbstractSecretKey clone = this.key.clone();
        this.key.setSecret(null);
        Assert.assertThat((Object)clone.getSecret(), (Matcher)CoreMatchers.is((Object)secret));
    }

    @Test
    public void testObjectSerialization() throws Exception {
        Assert.assertEquals(this.key, AbstractSecretKeyTestSuite.cloneViaObjectSerialization(512, this.updateTransientProperties(this.key)));
    }

    private static <T> T cloneViaObjectSerialization(int sizeHint, T original) throws IOException, ClassNotFoundException {
        byte[] serialized;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(sizeHint);){
            try (ObjectOutputStream _ = new ObjectOutputStream(bos);){
                _.writeObject(original);
            }
            bos.flush();
            serialized = bos.toByteArray();
        }
        logger.trace("Serialized object to {} bytes.", (Object)serialized.length);
        var4_3 = null;
        try (ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(serialized));){
            Object object = ois.readObject();
            return (T)object;
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testXmlSerialization() throws Exception {
        Assert.assertEquals(this.key, AbstractSecretKeyTestSuite.cloneViaXmlSerialization(512, this.updateTransientProperties(this.key)));
    }

    private static <T> T cloneViaXmlSerialization(int sizeHint, T original) throws IOException {
        byte[] serialized;
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(sizeHint);){
            try (XMLEncoder _ = new XMLEncoder(bos);){
                _.writeObject(original);
            }
            bos.flush();
            serialized = bos.toByteArray();
        }
        logger.trace("Serialized object to {} bytes.", (Object)serialized.length);
        logger.trace("Serialized form:\n{}", (Object)new String(serialized, StandardCharsets.UTF_8));
        var4_3 = null;
        try (XMLDecoder dec = new XMLDecoder(new ByteArrayInputStream(serialized));){
            Object object = dec.readObject();
            return (T)object;
        }
        catch (Throwable throwable) {
            var4_3 = throwable;
            throw throwable;
        }
    }

    protected K updateTransientProperties(K key) {
        key = key.clone();
        key.setSecret(Buffers.byteBuffer((String)"This secret must not get serialized!"));
        return key;
    }
}

