/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.srcgenerator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.NoType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.tools.Diagnostic;
import net.java.quickcheck.srcgenerator.Assertion;
import net.java.quickcheck.srcgenerator.Parameter;
import net.java.quickcheck.srcgenerator.Traversal;
import net.java.quickcheck.srcgenerator.Type;
import net.java.quickcheck.srcgenerator.TypeParameter;

class Method {
    final String name;
    final Type returnType;
    final List<Parameter> parameters = new ArrayList<Parameter>();
    final List<TypeParameter> typeParameters = new ArrayList<TypeParameter>();
    private final Messager messager;
    static final String GENERATOR_TYPE_NAME = "net.java.quickcheck.Generator";

    Method(CharSequence name, CharSequence returnType, Parameter ... parameters) {
        this(name, returnType, Collections.emptyList(), Arrays.asList(parameters), false);
    }

    Method(CharSequence name, CharSequence returnType, List<TypeParameter> typeParameters, List<Parameter> parameters, boolean generic) {
        Assertion.assertNotNull(name, "name");
        Assertion.assertNotNull(returnType, "returnType");
        Assertion.assertNotNull(typeParameters, "typeParameters");
        Assertion.assertNotNull(parameters, "parameters");
        Assertion.assertNotNull(generic, "generic");
        this.messager = null;
        this.name = ((Object)name).toString();
        this.returnType = new Type(returnType, generic);
        this.typeParameters.addAll(typeParameters);
        this.parameters.addAll(parameters);
    }

    Method(Messager messager, ExecutableElement method) {
        Assertion.assertNotNull(messager, "messager");
        this.messager = messager;
        this.messager.printMessage(Diagnostic.Kind.NOTE, String.format("Start method %s", method));
        this.parameters.addAll(this.parameters(method));
        this.name = method.getSimpleName().toString();
        this.returnType = this.returnTypeName(method);
        for (TypeParameterElement typeParameterElement : method.getTypeParameters()) {
            this.typeParameters.add(new TypeParameter(typeParameterElement));
        }
    }

    private List<Parameter> parameters(ExecutableElement method) {
        ArrayList<Parameter> ps = new ArrayList<Parameter>();
        for (VariableElement variableElement : method.getParameters()) {
            ps.add(new Parameter(variableElement.getSimpleName(), ((Object)variableElement.asType()).toString()));
        }
        return ps;
    }

    private Type returnTypeName(ExecutableElement method) {
        this.verifyReturnType(method);
        List<? extends TypeMirror> typeArguments = Traversal.toDeclaredType(method.getReturnType()).getTypeArguments();
        Assertion.assertTrue(typeArguments.size() > 0, "type argument expected", new Object[0]);
        TypeMirror next = typeArguments.get(typeArguments.size() - 1);
        return new Type(((Object)next).toString(), next instanceof TypeVariable);
    }

    private void verifyReturnType(ExecutableElement method) {
        TypeMirror type = method.getReturnType();
        Assertion.assertTrue(this.isSubtypeOfGenerator(type), "The return type [%s] is not an implementation of %s.", method, GENERATOR_TYPE_NAME);
        Assertion.assertTrue(this.isInterface(type), "The return type (%s) has to be an interface.", type);
    }

    private boolean isInterface(TypeMirror typeMirror) {
        return Traversal.toTypeElement(typeMirror).getKind() == ElementKind.INTERFACE;
    }

    private boolean isSubtypeOfGenerator(TypeMirror type) {
        if (type instanceof NoType) {
            return false;
        }
        if (Traversal.toTypeElement(type).getQualifiedName().contentEquals(GENERATOR_TYPE_NAME)) {
            return true;
        }
        for (TypeMirror typeMirror : Traversal.toTypeElement(type).getInterfaces()) {
            if (!this.isSubtypeOfGenerator(typeMirror)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Method)) {
            return false;
        }
        Method method = (Method)other;
        return method.name.equals(this.name) && method.returnType.equals(this.returnType) && ((Object)method.parameters).equals(this.parameters) && ((Object)method.typeParameters).equals(this.typeParameters);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return String.format("Method[name=%s, returnType=%s, typeParameter=%s,parameters=%s]", this.name, this.returnType, this.typeParameters, this.parameters);
    }
}

