/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.srcgenerator;

import java.io.IOException;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Set;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import net.java.quickcheck.srcgenerator.ClassInfo;
import net.java.quickcheck.srcgenerator.ClassRenderer;

public abstract class BaseProcessor
implements Processor {
    private ProcessingEnvironment env;

    protected abstract Class<? extends Annotation> getSupportedAnnotationType();

    protected abstract ClassRenderer createRenderer(ClassInfo var1);

    @Override
    public boolean process(Set<? extends TypeElement> annotatedType, RoundEnvironment roundEnv) {
        Set<? extends Element> annotated = roundEnv.getElementsAnnotatedWith(this.getSupportedAnnotationType());
        if (roundEnv.processingOver() || annotated.isEmpty()) {
            return false;
        }
        for (Element element : annotated) {
            this.processType(element);
        }
        return false;
    }

    private void processType(Element e) {
        ClassInfo info = new ClassInfo(this.env, e);
        ClassRenderer builder = this.createRenderer(info);
        String generatedType = builder.getGeneratedClassName();
        this.writeToFile(String.format("%s.%s", info.packageName, generatedType), builder.build());
        this.env.getMessager().printMessage(Diagnostic.Kind.NOTE, "wrote " + generatedType);
    }

    private void writeToFile(String generatedType, String code) {
        try {
            Writer out = this.env.getFiler().createSourceFile(generatedType, new Element[0]).openWriter();
            out.write(code);
            out.close();
            this.env.getMessager().printMessage(Diagnostic.Kind.NOTE, "wrote " + generatedType);
        }
        catch (IOException e) {
            this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
        }
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return Collections.emptyList();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(this.getSupportedAnnotationType().getName());
    }

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.emptySet();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_6;
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        this.env = processingEnv;
    }
}

