/*
 * Decompiled with CFR 0.152.
 */
package net.java.quickcheck.srcgenerator;

import net.java.quickcheck.srcgenerator.ClassInfo;
import net.java.quickcheck.srcgenerator.ClassRenderer;
import net.java.quickcheck.srcgenerator.Method;
import net.java.quickcheck.srcgenerator.Parameter;
import net.java.quickcheck.srcgenerator.Type;
import net.java.quickcheck.srcgenerator.TypeParameter;

abstract class BaseClassRenderer
implements ClassRenderer {
    ClassInfo info;
    private int level = 0;

    BaseClassRenderer(ClassInfo info) {
        this.info = info;
    }

    @Override
    public String build() {
        StringBuilder b = new StringBuilder();
        this.writeln(b, "package %s;\n", this.info.packageName);
        this.write(b, "public class %s", this.getGeneratedClassName());
        this.openBrace(b);
        for (Method m : this.info.methods) {
            this.writeMethod(b, m);
        }
        this.closeBrace(b);
        return b.toString();
    }

    void writeMethod(StringBuilder b, Method method) {
        this.writeMethodSignature(b, method);
        this.openBrace(b);
        this.writeln(b, this.methodContent(method), new Object[0]);
        this.closeBrace(b);
    }

    protected abstract String methodContent(Method var1);

    private void writeMethodSignature(StringBuilder b, Method method) {
        this.write(b, "public static %s %s %s(%s)", this.typeParameters(method), this.returnType(method), this.methodName(method), this.parameters(method));
    }

    protected abstract String methodName(Method var1);

    String typeParameter(Type returnType) {
        StringBuilder r = new StringBuilder();
        if (returnType.generic) {
            r.append("<").append(returnType.name).append("> ");
        }
        return r.toString();
    }

    protected abstract String returnType(Method var1);

    String typeParameters(Method method) {
        if (method.typeParameters.isEmpty()) {
            return "";
        }
        StringBuilder r = new StringBuilder();
        r.append("<");
        for (int i = 0; i < method.typeParameters.size(); ++i) {
            r.append(this.typeParameter(method.typeParameters.get(i)));
            if (i == method.typeParameters.size() - 1) continue;
            r.append(",");
        }
        r.append("> ");
        return r.toString();
    }

    private String typeParameter(TypeParameter typeParameter) {
        String bound = typeParameter.bound;
        return bound == null ? typeParameter.type : String.format("%s extends %s", typeParameter.type, bound);
    }

    String arguments(Method method) {
        StringBuilder ps = new StringBuilder();
        for (Parameter p : method.parameters) {
            if (ps.length() != 0) {
                ps.append(", ");
            }
            ps.append(p.name);
        }
        return ps.toString();
    }

    String parameters(Method method) {
        StringBuilder ps = new StringBuilder();
        for (Parameter p : method.parameters) {
            if (ps.length() != 0) {
                ps.append(", ");
            }
            ps.append(String.format("%s %s", p.type, p.name));
        }
        return ps.toString();
    }

    void writeln(StringBuilder w, String template, Object ... args) {
        this.write(w, template, args);
        this.write(w, "\n", new Object[0]);
    }

    void write(StringBuilder w, String template, Object ... args) {
        for (int i = 0; i < this.level; ++i) {
            w.append("    ");
        }
        w.append(String.format(template, args));
    }

    void openBrace(StringBuilder w) {
        w.append("{\n");
        ++this.level;
    }

    void closeBrace(StringBuilder w) {
        --this.level;
        this.writeln(w, "}", new Object[0]);
    }

    String generatorInstance(Method method) {
        return String.format("%s.%s.%s%s(%s)", this.info.packageName, this.info.className, this.typeParameter(method.returnType), method.name, this.arguments(method));
    }
}

