/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class Sftp
implements Runnable {
    InputStream in;
    OutputStream out;
    ChannelSftp c;
    private byte[] lf = new byte[]{10, 13};
    private byte[] del = new byte[]{8, 32, 8};
    private Thread thread = null;
    private static String[] help = new String[]{"      Available commands:", "      * means unimplemented command.", "cd [path]                     Change remote directory to 'path'", "lcd [path]                    Change local directory to 'path'", "chgrp grp path                Change group of file 'path' to 'grp'", "chmod mode path               Change permissions of file 'path' to 'mode'", "chown own path                Change owner of file 'path' to 'own'", "help                          Display this help text", "get remote-path [local-path]  Download file", "lls [path]                    Display local directory listing", "ln oldpath newpath            Symlink remote file", "lmkdir path                   Create local directory", "lpwd                          Print local working directory", "ls [path]                     Display remote directory listing", "*lumask umask                 Set local umask to 'umask'", "mkdir path                    Create remote directory", "put local-path [remote-path]  Upload file", "pwd                           Display remote working directory", "stat path                     Display info about path\nexit                          Quit sftp", "quit                          Quit sftp", "rename oldpath newpath        Rename remote file", "rmdir path                    Remove remote directory", "rm path                       Delete remote file", "symlink oldpath newpath       Symlink remote file", "version                       Show SFTP version", "?                             Synonym for help"};

    public Sftp(ChannelSftp channelSftp, InputStream inputStream, OutputStream outputStream) {
        this.c = channelSftp;
        this.in = inputStream;
        this.out = outputStream;
    }

    @Override
    public void run() {
        try {
            Vector<String> vector = new Vector<String>();
            byte[] byArray = new byte[1024];
            String string = this.c.lpwd();
            StringBuffer stringBuffer = new StringBuffer();
            while (true) {
                int n;
                int n2;
                int n3;
                this.out.write("sftp> ".getBytes());
                vector.removeAllElements();
                stringBuffer.setLength(0);
                block25: while ((n3 = this.in.read(byArray, 0, 1024)) > 0) {
                    if (n3 != 1) continue;
                    if (byArray[0] == 8) {
                        if (stringBuffer.length() <= 0) continue;
                        stringBuffer.setLength(stringBuffer.length() - 1);
                        this.out.write(this.del, 0, this.del.length);
                        this.out.flush();
                        continue;
                    }
                    if (byArray[0] == 13) {
                        this.out.write(this.lf, 0, this.lf.length);
                    } else if (byArray[0] == 10) {
                        this.out.write(this.lf, 0, this.lf.length);
                    } else {
                        if (byArray[0] < 32 || (byArray[0] & 0x80) != 0) continue;
                        this.out.write(byArray, 0, n3);
                    }
                    this.out.flush();
                    for (n2 = 0; n2 < n3; ++n2) {
                        stringBuffer.append((char)byArray[n2]);
                        if (byArray[n2] == 13) {
                            System.arraycopy(stringBuffer.toString().getBytes(), 0, byArray, 0, stringBuffer.length());
                            n3 = stringBuffer.length();
                            break block25;
                        }
                        if (byArray[n2] != 10) continue;
                        System.arraycopy(stringBuffer.toString().getBytes(), 0, byArray, 0, stringBuffer.length());
                        n3 = stringBuffer.length();
                        break block25;
                    }
                }
                if (n3 <= 0) break;
                if (--n3 > 0 && byArray[n3 - 1] == 13) {
                    --n3;
                }
                if (n3 > 0 && byArray[n3 - 1] == 10) {
                    --n3;
                }
                n2 = 0;
                for (int i = 0; i < n3; ++i) {
                    if (byArray[i] != 32) continue;
                    if (i - n2 > 0) {
                        vector.addElement(new String(byArray, n2, i - n2));
                    }
                    while (i < n3 && byArray[i] == 32) {
                        ++i;
                    }
                    n2 = i;
                }
                if (n2 < n3) {
                    vector.addElement(new String(byArray, n2, n3 - n2));
                }
                if (vector.size() == 0) continue;
                String string2 = (String)vector.elementAt(0);
                if (string2.equals("quit")) {
                    this.c.quit();
                    break;
                }
                if (string2.equals("exit")) {
                    this.c.exit();
                    break;
                }
                if (string2.equals("cd") || string2.equals("lcd")) {
                    String string3 = null;
                    string3 = vector.size() < 2 ? (string2.equals("cd") ? this.c.getHome() : string) : (String)vector.elementAt(1);
                    try {
                        if (string2.equals("cd")) {
                            this.c.cd(string3);
                            continue;
                        }
                        this.c.lcd(string3);
                    }
                    catch (SftpException sftpException) {
                        this.out.write(sftpException.getMessage().getBytes());
                        this.out.write(this.lf);
                        this.out.flush();
                    }
                    continue;
                }
                if (string2.equals("rm") || string2.equals("rmdir") || string2.equals("mkdir")) {
                    if (vector.size() < 2) continue;
                    String string4 = (String)vector.elementAt(1);
                    try {
                        if (string2.equals("rm")) {
                            this.c.rm(string4);
                            continue;
                        }
                        if (string2.equals("rmdir")) {
                            this.c.rmdir(string4);
                            continue;
                        }
                        this.c.mkdir(string4);
                    }
                    catch (SftpException sftpException) {
                        this.out.write(sftpException.getMessage().getBytes());
                        this.out.write(this.lf);
                        this.out.flush();
                    }
                    continue;
                }
                if (string2.equals("lmkdir")) {
                    if (vector.size() < 2) continue;
                    String string5 = (String)vector.elementAt(1);
                    File file = new File(this.c.lpwd(), string5);
                    if (file.mkdir()) continue;
                    this.out.write("failed to make directory".getBytes());
                    this.out.write(this.lf);
                    this.out.flush();
                    continue;
                }
                if (string2.equals("chgrp") || string2.equals("chown") || string2.equals("chmod")) {
                    if (vector.size() != 3) continue;
                    String string6 = (String)vector.elementAt(2);
                    int n4 = 0;
                    if (string2.equals("chmod")) {
                        byte[] byArray2 = ((String)vector.elementAt(1)).getBytes();
                        for (int i = 0; i < byArray2.length; ++i) {
                            n = byArray2[i];
                            if (n < 48 || n > 55) {
                                n4 = -1;
                                break;
                            }
                            n4 <<= 3;
                            n4 |= n - 48;
                        }
                        if (n4 == -1) {
                            continue;
                        }
                    } else {
                        try {
                            n4 = Integer.parseInt((String)vector.elementAt(1));
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    try {
                        if (string2.equals("chgrp")) {
                            this.c.chgrp(n4, string6);
                            continue;
                        }
                        if (string2.equals("chown")) {
                            this.c.chown(n4, string6);
                            continue;
                        }
                        if (!string2.equals("chmod")) continue;
                        this.c.chmod(n4, string6);
                    }
                    catch (SftpException sftpException) {
                        this.out.write(sftpException.getMessage().getBytes());
                        this.out.write(this.lf);
                        this.out.flush();
                    }
                    continue;
                }
                if (string2.equals("pwd") || string2.equals("lpwd")) {
                    String string7 = string2.equals("pwd") ? "Remote" : "Local";
                    string7 = string7 + " working directory: ";
                    string7 = string2.equals("pwd") ? string7 + this.c.pwd() : string7 + this.c.lpwd();
                    this.out.write(string7.getBytes());
                    this.out.write(this.lf);
                    this.out.flush();
                    continue;
                }
                if (string2.equals("ls") || string2.equals("dir")) {
                    String string8 = ".";
                    if (vector.size() == 2) {
                        string8 = (String)vector.elementAt(1);
                    }
                    try {
                        Vector vector2 = this.c.ls(string8);
                        if (vector2 == null) continue;
                        for (int i = 0; i < vector2.size(); ++i) {
                            this.out.write(vector2.elementAt(i).toString().getBytes());
                            this.out.write(this.lf);
                        }
                        this.out.flush();
                    }
                    catch (SftpException sftpException) {
                        this.out.write(sftpException.getMessage().getBytes());
                        this.out.write(this.lf);
                        this.out.flush();
                    }
                    continue;
                }
                if (string2.equals("lls")) {
                    String string9 = this.c.lpwd();
                    if (vector.size() == 2) {
                        string9 = (String)vector.elementAt(1);
                    }
                    try {
                        File file = new File(string9);
                        String[] stringArray = file.list();
                        for (n = 0; n < stringArray.length; ++n) {
                            this.out.write(stringArray[n].getBytes());
                            this.out.write(this.lf);
                        }
                        this.out.flush();
                    }
                    catch (IOException iOException) {
                        this.out.write(iOException.getMessage().getBytes());
                        this.out.write(this.lf);
                        this.out.flush();
                    }
                    continue;
                }
                if (string2.equals("get") || string2.equals("put")) {
                    if (vector.size() != 2 && vector.size() != 3) continue;
                    String string10 = (String)vector.elementAt(1);
                    String string11 = ".";
                    if (vector.size() == 3) {
                        string11 = (String)vector.elementAt(2);
                    }
                    try {
                        MyProgressMonitor myProgressMonitor = new MyProgressMonitor(this.out);
                        if (string2.equals("get")) {
                            this.c.get(string10, string11, (SftpProgressMonitor)myProgressMonitor);
                            continue;
                        }
                        this.c.put(string10, string11, (SftpProgressMonitor)myProgressMonitor);
                    }
                    catch (SftpException sftpException) {
                        this.out.write(sftpException.getMessage().getBytes());
                        this.out.write(this.lf);
                        this.out.flush();
                    }
                    continue;
                }
                if (string2.equals("ln") || string2.equals("symlink") || string2.equals("rename")) {
                    if (vector.size() != 3) continue;
                    String string12 = (String)vector.elementAt(1);
                    String string13 = (String)vector.elementAt(2);
                    try {
                        if (string2.equals("rename")) {
                            this.c.rename(string12, string13);
                            continue;
                        }
                        this.c.symlink(string12, string13);
                    }
                    catch (SftpException sftpException) {
                        this.out.write(sftpException.getMessage().getBytes());
                        this.out.write(this.lf);
                        this.out.flush();
                    }
                    continue;
                }
                if (string2.equals("stat") || string2.equals("lstat")) {
                    if (vector.size() != 2) continue;
                    String string14 = (String)vector.elementAt(1);
                    SftpATTRS sftpATTRS = null;
                    try {
                        sftpATTRS = string2.equals("stat") ? this.c.stat(string14) : this.c.lstat(string14);
                    }
                    catch (SftpException sftpException) {
                        this.out.write(sftpException.getMessage().getBytes());
                        this.out.write(this.lf);
                        this.out.flush();
                    }
                    if (sftpATTRS == null) continue;
                    this.out.write(sftpATTRS.toString().getBytes());
                    this.out.write(this.lf);
                    this.out.flush();
                    continue;
                }
                if (string2.equals("version")) {
                    this.out.write(("SFTP protocol version " + this.c.version()).getBytes());
                    this.out.write(this.lf);
                    this.out.flush();
                    continue;
                }
                if (string2.equals("help") || string2.equals("help")) {
                    for (int i = 0; i < help.length; ++i) {
                        this.out.write(help[i].getBytes());
                        this.out.write(this.lf);
                    }
                    this.out.flush();
                    continue;
                }
                this.out.write(("unimplemented command: " + string2).getBytes());
                this.out.write(this.lf);
                this.out.flush();
            }
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (Exception exception) {}
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void kick() {
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    public static class MyProgressMonitor
    implements SftpProgressMonitor {
        OutputStream out;
        long count = 0L;
        long max = 0L;
        String src;
        int percent = 0;

        MyProgressMonitor(OutputStream outputStream) {
            this.out = outputStream;
        }

        public void init(int n, String string, String string2, long l) {
            this.max = l;
            this.src = string;
            this.count = 0L;
            this.percent = 0;
            this.status();
        }

        public boolean count(long l) {
            this.count += l;
            this.percent = (int)((double)((float)this.count / (float)this.max) * 100.0);
            this.status();
            return true;
        }

        public void end() {
            this.percent = (int)((double)((float)this.count / (float)this.max) * 100.0);
            this.status();
            try {
                this.out.write(13);
                this.out.write(10);
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void status() {
            try {
                this.out.write(13);
                this.out.write(27);
                this.out.write(91);
                this.out.write(75);
                this.out.write((this.src + ": " + this.percent + "% " + this.count + "/" + this.max).getBytes());
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

