/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jsch.IdentityRepository;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import java.util.Hashtable;

public class JSchSession {
    private static JSch jsch = null;
    private static SessionFactory sessionFactory = null;
    private static Hashtable pool = new Hashtable();
    private String key = null;
    private Session session = null;

    public static JSchSession getSession(String string, String string2, String string3, int n, UserInfo userInfo, Proxy proxy) throws JSchException {
        String string4 = JSchSession.getPoolKey(string, string3, n);
        try {
            JSchSession jSchSession = (JSchSession)pool.get(string4);
            if (jSchSession != null && !jSchSession.getSession().isConnected()) {
                pool.remove(string4);
                jSchSession = null;
            }
            if (jSchSession == null) {
                Session session = null;
                try {
                    session = JSchSession.createSession(string, string2, string3, n, userInfo, proxy);
                }
                catch (JSchException jSchException) {
                    if (JSchSession.isAuthenticationFailure(jSchException)) {
                        session = JSchSession.createSession(string, string2, string3, n, userInfo, proxy);
                    }
                    throw jSchException;
                }
                if (session == null) {
                    throw new JSchException("The JSch service is not available");
                }
                JSchSession jSchSession2 = new JSchSession(session, string4);
                pool.put(string4, jSchSession2);
                return jSchSession2;
            }
            return jSchSession;
        }
        catch (JSchException jSchException) {
            pool.remove(string4);
            throw jSchException;
        }
    }

    private static synchronized JSch getJSch() {
        if (jsch == null) {
            jsch = new JSch();
        }
        return jsch;
    }

    private static Session createSession(String string, String string2, String string3, int n, UserInfo userInfo, Proxy proxy) throws JSchException {
        Session session = null;
        session = sessionFactory == null ? JSchSession.getJSch().getSession(string, string3, n) : sessionFactory.getSession(string, string3, n);
        session.setTimeout(60000);
        if (string2 != null) {
            session.setPassword(string2);
        }
        session.setUserInfo(userInfo);
        if (proxy != null) {
            session.setProxy(proxy);
        }
        session.connect(60000);
        session.setServerAliveInterval(60000);
        return session;
    }

    private static String getPoolKey(String string, String string2, int n) {
        return string + "@" + string2 + ":" + n;
    }

    private JSchSession(Session session, String string) {
        this.session = session;
        this.key = string;
    }

    public Session getSession() {
        return this.session;
    }

    public void dispose() {
        if (this.session.isConnected()) {
            this.session.disconnect();
        }
        pool.remove(this.key);
    }

    public static boolean isAuthenticationFailure(JSchException jSchException) {
        return jSchException.getMessage().equals("Auth fail");
    }

    public static void setSessionFactory(SessionFactory sessionFactory) {
        JSchSession.sessionFactory = sessionFactory;
    }

    static void useSSHAgent(boolean bl) {
        IdentityRepository identityRepository = null;
        if (bl) {
            try {
                Class<?> clazz = Class.forName("com.jcraft.jcterm.JCTermIdentityRepository");
                identityRepository = (IdentityRepository)clazz.newInstance();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println(noClassDefFoundError);
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
            if (identityRepository == null) {
                System.err.println("JCTermIdentityRepository is not available.");
            }
        }
        if (identityRepository != null) {
            JSchSession.getJSch().setIdentityRepository(identityRepository);
        }
    }

    public static interface SessionFactory {
        public Session getSession(String var1, String var2, int var3) throws JSchException;
    }
}

