/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jcterm.Configuration;
import com.jcraft.jcterm.ConfigurationRepositoryFS;
import com.jcraft.jcterm.Connection;
import com.jcraft.jcterm.Frame;
import com.jcraft.jcterm.JCTermSwing;
import com.jcraft.jcterm.JSchSession;
import com.jcraft.jcterm.Sftp;
import com.jcraft.jcterm.Splash;
import com.jcraft.jcterm.Term;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class JCTermSwingFrame
extends JFrame
implements Frame,
ActionListener,
Runnable {
    static String COPYRIGHT = "JCTerm 0.0.11\nCopyright (C) 2002,2012 ymnk<ymnk@jcraft.com>, JCraft,Inc.\nOfficial Homepage: http://www.jcraft.com/jcterm/\nThis software is licensed under GNU LGPL.";
    private static int counter = 1;
    private int mode = 0;
    private String xhost = "127.0.0.1";
    private int xport = 0;
    private boolean xforwarding = false;
    private String user = "";
    private String host = "127.0.0.1";
    private String proxy_http_host = null;
    private int proxy_http_port = 0;
    private String proxy_socks5_host = null;
    private int proxy_socks5_port = 0;
    private JSchSession jschsession = null;
    private Proxy proxy = null;
    private int compression = 0;
    private Splash splash = null;
    private JCTermSwing term = null;
    private Connection connection = null;
    private Channel channel = null;
    private boolean close_on_exit = true;
    private Frame frame = this;
    private String configName = "default";
    private Thread thread = null;

    static void resetCounter() {
        counter = 1;
    }

    public boolean getCloseOnExit() {
        return this.close_on_exit;
    }

    public void setCloseOnExit(boolean bl) {
        this.close_on_exit = bl;
    }

    public JCTermSwingFrame() {
    }

    public JCTermSwingFrame(String string) {
        this(string, "default");
    }

    public JCTermSwingFrame(String string, String string2) {
        super(string);
        this.configName = string2;
        this.setDefaultCloseOperation(2);
        this.enableEvents(8L);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        JMenuBar jMenuBar = this.getJMenuBar();
        this.setJMenuBar(jMenuBar);
        this.term = new JCTermSwing();
        this.getContentPane().add("Center", this.term);
        this.pack();
        this.term.setVisible(true);
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Component component = componentEvent.getComponent();
                Container container = ((JFrame)component).getContentPane();
                int n = component.getWidth();
                int n2 = component.getHeight();
                int n3 = component.getWidth() - container.getWidth();
                int n4 = component.getHeight() - container.getHeight();
                JCTermSwingFrame.this.term.setSize(n -= n3, n2 -= n4);
            }
        };
        this.addComponentListener(componentAdapter);
        this.applyConfig(string2);
        this.openSession();
    }

    public void kick() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        String string = null;
        while (this.thread != null) {
            try {
                Object object;
                Object object2;
                Channel channel;
                int n = 22;
                try {
                    channel = JCTermSwing.getCR().load((String)this.configName).destinations;
                    object2 = this.promptDestination(this.term, (String[])channel);
                    string = object2;
                    if (object2 == null) break;
                    object = ((String)object2).substring(0, ((String)object2).indexOf(64));
                    if ((object2 = ((String)object2).substring(((String)object2).indexOf(64) + 1)) == null || ((String)object2).length() == 0) continue;
                    if (((String)object2).indexOf(58) != -1) {
                        try {
                            n = Integer.parseInt(((String)object2).substring(((String)object2).indexOf(58) + 1));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        object2 = ((String)object2).substring(0, ((String)object2).indexOf(58));
                    }
                    this.user = object;
                    this.host = object2;
                }
                catch (Exception exception) {
                    continue;
                }
                try {
                    channel = new MyUserInfo();
                    this.jschsession = JSchSession.getSession(this.user, null, this.host, n, (UserInfo)channel, this.proxy);
                    this.setCompression(this.compression);
                    object2 = JCTermSwing.getCR().load(this.configName);
                    ((Configuration)object2).addDestination(string);
                    JCTermSwing.getCR().save((Configuration)object2);
                }
                catch (Exception exception) {
                    break;
                }
                channel = null;
                object2 = null;
                object = null;
                if (this.mode == 0) {
                    channel = this.jschsession.getSession().openChannel("shell");
                    if (this.xforwarding) {
                        this.jschsession.getSession().setX11Host(this.xhost);
                        this.jschsession.getSession().setX11Port(this.xport + 6000);
                        channel.setXForwarding(true);
                    }
                    object2 = channel.getOutputStream();
                    object = channel.getInputStream();
                    channel.connect();
                } else if (this.mode == 1) {
                    object2 = new PipedOutputStream();
                    object = new PipedInputStream();
                    channel = this.jschsession.getSession().openChannel("sftp");
                    channel.connect();
                    new Sftp((ChannelSftp)channel, new PipedInputStream((PipedOutputStream)object2), new PipedOutputStream((PipedInputStream)object)).kick();
                }
                Object object3 = object2;
                String string2 = object;
                Channel channel2 = channel;
                this.connection = new Connection((InputStream)((Object)string2), (OutputStream)object3, channel2){
                    final /* synthetic */ InputStream val$fin;
                    final /* synthetic */ OutputStream val$fout;
                    final /* synthetic */ Channel val$fchannel;
                    {
                        this.val$fin = inputStream;
                        this.val$fout = outputStream;
                        this.val$fchannel = channel;
                    }

                    @Override
                    public InputStream getInputStream() {
                        return this.val$fin;
                    }

                    @Override
                    public OutputStream getOutputStream() {
                        return this.val$fout;
                    }

                    @Override
                    public void requestResize(Term term) {
                        if (this.val$fchannel instanceof ChannelShell) {
                            int n = term.getColumnCount();
                            int n2 = term.getRowCount();
                            ((ChannelShell)this.val$fchannel).setPtySize(n, n2, n * term.getCharWidth(), n2 * term.getCharHeight());
                        }
                    }

                    @Override
                    public void close() {
                        this.val$fchannel.disconnect();
                    }
                };
                this.frame.setTitle("[" + counter++ + "] " + this.user + "@" + this.host + (n != 22 ? ":" + new Integer(n).toString() : ""));
                this.term.requestFocus();
                this.term.start(this.connection);
                break;
            }
            catch (Exception exception) {
                // empty catch block
                break;
            }
        }
        this.frame.setTitle("JCTerm");
        this.thread = null;
        this.dispose_connection();
        if (this.getCloseOnExit()) {
            this.frame.setVisible(false);
            this.frame.dispose();
        } else {
            this.term.clear();
            this.term.redraw(0, 0, this.term.getWidth(), this.term.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_connection() {
        JCTermSwingFrame jCTermSwingFrame = this;
        synchronized (jCTermSwingFrame) {
            if (this.channel != null) {
                this.channel.disconnect();
                this.channel = null;
            }
        }
    }

    public void setProxyHttp(String string, int n) {
        this.proxy_http_host = string;
        this.proxy_http_port = n;
        this.proxy = this.proxy_http_host != null && this.proxy_http_port != 0 ? new ProxyHTTP(this.proxy_http_host, this.proxy_http_port) : null;
    }

    public String getProxyHttpHost() {
        return this.proxy_http_host;
    }

    public int getProxyHttpPort() {
        return this.proxy_http_port;
    }

    public void setProxySOCKS5(String string, int n) {
        this.proxy_socks5_host = string;
        this.proxy_socks5_port = n;
        this.proxy = this.proxy_socks5_host != null && this.proxy_socks5_port != 0 ? new ProxySOCKS5(this.proxy_socks5_host, this.proxy_socks5_port) : null;
    }

    public String getProxySOCKS5Host() {
        return this.proxy_socks5_host;
    }

    public int getProxySOCKS5Port() {
        return this.proxy_socks5_port;
    }

    public void setXHost(String string) {
        this.xhost = string;
    }

    public void setXPort(int n) {
        this.xport = n;
    }

    public void setXForwarding(boolean bl) {
        this.xforwarding = bl;
    }

    public void setCompression(int n) {
        if (n < 0 || 9 < n) {
            return;
        }
        this.compression = n;
        if (this.jschsession != null) {
            if (n == 0) {
                this.jschsession.getSession().setConfig("compression.s2c", "none");
                this.jschsession.getSession().setConfig("compression.c2s", "none");
                this.jschsession.getSession().setConfig("compression_level", "0");
            } else {
                this.jschsession.getSession().setConfig("compression.s2c", "zlib@openssh.com,zlib,none");
                this.jschsession.getSession().setConfig("compression.c2s", "zlib@openssh.com,zlib,none");
                this.jschsession.getSession().setConfig("compression_level", new Integer(n).toString());
            }
            try {
                this.jschsession.getSession().rekey();
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public void setFontSize(int n) {
        Configuration configuration = JCTermSwing.getCR().load(this.configName);
        configuration.font_size = n;
        JCTermSwing.getCR().save(configuration);
        this._setFontSize(n);
    }

    private void _setFontSize(int n) {
        int n2 = this.frame.getWidth() - this.term.getTermWidth();
        int n3 = this.frame.getHeight() - this.term.getTermHeight();
        this.term.setFont("Monospaced-" + n);
        this.frame.setSize(n2 + this.term.getTermWidth(), n3 + this.term.getTermHeight());
        this.term.clear();
        this.term.redraw(0, 0, this.term.getWidth(), this.term.getHeight());
    }

    public int getCompression() {
        return this.compression;
    }

    public void setLineSpace(int n) {
        this.term.setLineSpace(n);
    }

    public void setSplash(Splash splash) {
        this.splash = splash;
    }

    public boolean getAntiAliasing() {
        return this.term.getAntiAliasing();
    }

    public void setAntiAliasing(boolean bl) {
        this.term.setAntiAliasing(bl);
    }

    public void setUserHost(String string) {
        try {
            String string2 = string.substring(0, string.indexOf(64));
            String string3 = string.substring(string.indexOf(64) + 1);
            this.user = string2;
            this.host = string3;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void openSession() {
        this.kick();
    }

    public void setPortForwardingL(int n, String string, int n2) {
        if (this.jschsession == null) {
            return;
        }
        try {
            this.jschsession.getSession().setPortForwardingL(n, string, n2);
        }
        catch (JSchException jSchException) {
            // empty catch block
        }
    }

    public void setPortForwardingR(int n, String string, int n2) {
        if (this.jschsession == null) {
            return;
        }
        try {
            this.jschsession.getSession().setPortForwardingR(n, string, n2);
        }
        catch (JSchException jSchException) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block42: {
            String string = actionEvent.getActionCommand();
            int n = 0;
            if (string.equals("Open SHELL Session...")) {
                n = 0;
            } else if (string.equals("Open SFTP Session...")) {
                n = 1;
            }
            if (string.equals("Open SHELL Session...") || string.equals("Open SFTP Session...")) {
                if (this.thread == null) {
                    this.mode = n;
                    this.openSession();
                } else {
                    this.frame.openFrame(n, this.configName);
                }
            } else if (string.equals("HTTP...")) {
                String string2 = this.getProxyHttpHost();
                int n2 = this.getProxyHttpPort();
                String string3 = JOptionPane.showInputDialog(this, "HTTP proxy server (hostname:port)", string2 != null && n2 != 0 ? string2 + ":" + n2 : "");
                if (string3 == null) {
                    return;
                }
                if (string3.length() == 0) {
                    this.setProxyHttp(null, 0);
                    return;
                }
                try {
                    string2 = string3.substring(0, string3.indexOf(58));
                    n2 = Integer.parseInt(string3.substring(string3.indexOf(58) + 1));
                    if (string2 != null) {
                        this.setProxyHttp(string2, n2);
                    }
                }
                catch (Exception exception) {}
            } else if (string.equals("SOCKS5...")) {
                String string4 = this.getProxySOCKS5Host();
                int n3 = this.getProxySOCKS5Port();
                String string5 = JOptionPane.showInputDialog(this, "SOCKS5 server (hostname:1080)", string4 != null && n3 != 0 ? string4 + ":" + n3 : "");
                if (string5 == null) {
                    return;
                }
                if (string5.length() == 0) {
                    this.setProxySOCKS5(null, 0);
                    return;
                }
                try {
                    string4 = string5.substring(0, string5.indexOf(58));
                    n3 = Integer.parseInt(string5.substring(string5.indexOf(58) + 1));
                    if (string4 != null) {
                        this.setProxySOCKS5(string4, n3);
                    }
                }
                catch (Exception exception) {}
            } else if (string.equals("X11 Forwarding...")) {
                String string6 = JOptionPane.showInputDialog(this, "XDisplay name (hostname:0)", this.xhost == null ? "" : this.xhost + ":" + this.xport);
                try {
                    if (string6 != null) {
                        this.xhost = string6.substring(0, string6.indexOf(58));
                        this.xport = Integer.parseInt(string6.substring(string6.indexOf(58) + 1));
                        this.xforwarding = true;
                    }
                }
                catch (Exception exception) {
                    this.xforwarding = false;
                    this.xhost = null;
                }
            } else if (string.equals("AntiAliasing")) {
                this.setAntiAliasing(!this.getAntiAliasing());
            } else if (string.equals("Compression...")) {
                String string7 = JOptionPane.showInputDialog(this, "Compression level(0-9)\n0 means no compression.\n1 means fast.\n9 means slow, but best.", new Integer(this.compression).toString());
                try {
                    if (string7 != null) {
                        this.compression = Integer.parseInt(string7);
                        this.setCompression(this.compression);
                    }
                }
                catch (Exception exception) {}
            } else {
                if (string.equals("About...")) {
                    JOptionPane.showMessageDialog(this, COPYRIGHT);
                    return;
                }
                if (string.equals("Local Port...") || string.equals("Remote Port...")) {
                    if (this.jschsession == null) {
                        JOptionPane.showMessageDialog(this, "Establish the connection before this setting.");
                        return;
                    }
                    try {
                        String string8 = "";
                        string8 = string.equals("Local Port...") ? string8 + "Local port forwarding" : string8 + "remote port forwarding";
                        string8 = string8 + "(port:host:hostport)";
                        String string9 = JOptionPane.showInputDialog(this, string8, "");
                        if (string9 == null) {
                            return;
                        }
                        int n4 = Integer.parseInt(string9.substring(0, string9.indexOf(58)));
                        string9 = string9.substring(string9.indexOf(58) + 1);
                        String string10 = string9.substring(0, string9.indexOf(58));
                        int n5 = Integer.parseInt(string9.substring(string9.indexOf(58) + 1));
                        if (string.equals("Local Port...")) {
                            this.setPortForwardingL(n4, string10, n5);
                            break block42;
                        }
                        this.setPortForwardingR(n4, string10, n5);
                    }
                    catch (Exception exception) {}
                } else if (string.equals("Quit")) {
                    this.quit();
                }
            }
        }
    }

    @Override
    public JMenuBar getJMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenuItem jMenuItem = new JMenuItem("Open SHELL Session...");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Open SHELL Session...");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Open SFTP Session...");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Open SFTP Session...");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Quit");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Quit");
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Proxy");
        jMenuItem = new JMenuItem("HTTP...");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("HTTP...");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("SOCKS5...");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("SOCKS5...");
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("PortForwarding");
        jMenuItem = new JMenuItem("Local Port...");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Local Port...");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Remote Port...");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Remote Port...");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("X11 Forwarding...");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("X11 Forwarding...");
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Etc");
        jMenuItem = new JMenuItem("AntiAliasing");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("AntiAliasing");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Compression...");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Compression...");
        jMenu.add(jMenuItem);
        JMenu jMenu2 = new JMenu("Color");
        final ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCTermSwingFrame.this.setFgBg(actionEvent.getActionCommand());
            }
        };
        jMenu2.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                JMenu jMenu = (JMenu)menuEvent.getSource();
                String[] stringArray = JCTermSwing.getCR().load((String)((JCTermSwingFrame)JCTermSwingFrame.this).configName).fg_bg;
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray2 = stringArray[i].split(":");
                    JMenuItem jMenuItem = new JMenuItem("ABC");
                    jMenuItem.setForeground(JCTermSwing.toColor(stringArray2[0]));
                    jMenuItem.setBackground(JCTermSwing.toColor(stringArray2[1]));
                    jMenuItem.setActionCommand(stringArray[i]);
                    jMenuItem.addActionListener(actionListener);
                    jMenu.add(jMenuItem);
                }
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                JMenu jMenu = (JMenu)menuEvent.getSource();
                jMenu.removeAll();
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        jMenu.add(jMenu2);
        JMenu jMenu3 = new JMenu("Font size");
        final ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                try {
                    JCTermSwingFrame.this.setFontSize(Integer.parseInt(string));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        };
        jMenu3.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                JMenu jMenu = (JMenu)menuEvent.getSource();
                int n = JCTermSwing.getCR().load((String)((JCTermSwingFrame)JCTermSwingFrame.this).configName).font_size;
                JMenuItem jMenuItem = new JMenuItem("Smaller (" + (n - 1) + ")");
                jMenuItem.setActionCommand("" + (n - 1));
                jMenuItem.addActionListener(actionListener2);
                jMenu.add(jMenuItem);
                jMenuItem = new JMenuItem("Larger (" + (n + 1) + ")");
                jMenuItem.setActionCommand("" + (n + 1));
                jMenuItem.addActionListener(actionListener2);
                jMenu.add(jMenuItem);
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
                JMenu jMenu = (JMenu)menuEvent.getSource();
                jMenu.removeAll();
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        jMenu.add(jMenu3);
        jMenuBar.add(jMenu);
        jMenu = new JMenu("Help");
        jMenuItem = new JMenuItem("About...");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("About...");
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    public void quit() {
        this.thread = null;
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void setTerm(JCTermSwing jCTermSwing) {
        this.term = jCTermSwing;
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public void openFrame(int n, String string) {
        JCTermSwingFrame jCTermSwingFrame = new JCTermSwingFrame("JCTerm", string);
        jCTermSwingFrame.mode = n;
        jCTermSwingFrame.setXForwarding(true);
        jCTermSwingFrame.setXPort(this.xport);
        jCTermSwingFrame.setXHost(this.xhost);
        jCTermSwingFrame.setLocationRelativeTo(null);
        jCTermSwingFrame.setVisible(true);
        jCTermSwingFrame.setResizable(true);
    }

    void setFgBg(String string) {
        Configuration configuration = JCTermSwing.getCR().load(this.configName);
        configuration.addFgBg(string);
        JCTermSwing.getCR().save(configuration);
        this._setFgBg(string);
    }

    private void _setFgBg(String string) {
        String[] stringArray = string.split(":");
        Color color = JCTermSwing.toColor(stringArray[0]);
        Color color2 = JCTermSwing.toColor(stringArray[1]);
        this.term.setForeGround(color);
        this.term.setDefaultForeGround(color);
        this.term.setBackGround(color2);
        this.term.setDefaultBackGround(color2);
        this.term.resetCursorGraphics();
        this.term.clear();
        this.term.redraw(0, 0, this.term.getWidth(), this.term.getHeight());
    }

    private String promptDestination(JComponent jComponent, String[] stringArray) {
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.setEditable(true);
        for (int i = 0; i < stringArray.length; ++i) {
            jComboBox.addItem(stringArray[i]);
        }
        JPanel jPanel = new JPanel();
        jComboBox.requestFocusInWindow();
        JOptionPane jOptionPane = new JOptionPane(jComboBox, 3, 2){

            @Override
            public void selectInitialValue() {
            }
        };
        JDialog jDialog = jOptionPane.createDialog(this.term, "Enter username@hostname");
        jDialog.setDefaultCloseOperation(2);
        jDialog.setVisible(true);
        Object object = jOptionPane.getValue();
        String string = null;
        if (object != null && (Integer)object == 0) {
            string = (String)jComboBox.getSelectedItem();
        }
        if (string == null || string.length() == 0) {
            return null;
        }
        return string;
    }

    void setFrame(Frame frame) {
        this.frame = frame;
    }

    void applyConfig(String string) {
        this.configName = string;
        Configuration configuration = JCTermSwing.getCR().load(string);
        this._setFontSize(configuration.font_size);
        this._setFgBg(configuration.fg_bg[0]);
    }

    public static void main(String[] stringArray) {
        JCTermSwing.setCR(new ConfigurationRepositoryFS());
        String string = System.getProperty("jcterm.config.use_ssh_agent");
        if (string != null && string.equals("true")) {
            JSchSession.useSSHAgent(true);
        }
        JCTermSwingFrame jCTermSwingFrame = new JCTermSwingFrame("JCTerm");
        jCTermSwingFrame.setCloseOnExit(false);
        jCTermSwingFrame.setVisible(true);
        jCTermSwingFrame.setResizable(true);
    }

    public class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        String passwd = null;
        String passphrase = null;
        JTextField pword = new JPasswordField(20);
        final GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        private Container panel;

        public boolean promptYesNo(String string) {
            Object[] objectArray = new Object[]{"yes", "no"};
            int n = JOptionPane.showOptionDialog(JCTermSwingFrame.this.term, string, "Warning", -1, 2, null, objectArray, objectArray[0]);
            return n == 0;
        }

        public String getPassword() {
            return this.passwd;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public boolean promptPassword(String string) {
            Object[] objectArray = new Object[]{this.pword};
            JPanel jPanel = new JPanel();
            jPanel.add(this.pword);
            this.pword.requestFocusInWindow();
            JOptionPane jOptionPane = new JOptionPane(jPanel, 3, 2){

                @Override
                public void selectInitialValue() {
                }
            };
            JDialog jDialog = jOptionPane.createDialog(JCTermSwingFrame.this.term, string);
            jDialog.setDefaultCloseOperation(2);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object != null && (Integer)object == 0) {
                this.passwd = this.pword.getText();
                return true;
            }
            return false;
        }

        public boolean promptPassphrase(String string) {
            return true;
        }

        public void showMessage(String string) {
            JOptionPane.showMessageDialog(null, string);
        }

        public String[] promptKeyboardInteractive(String string, String string2, String string3, String[] stringArray, boolean[] blArray) {
            int n;
            this.panel = new JPanel();
            this.panel.setLayout(new GridBagLayout());
            this.gbc.weightx = 1.0;
            this.gbc.gridwidth = 0;
            this.gbc.gridx = 0;
            this.panel.add((Component)new JLabel(string3), this.gbc);
            ++this.gbc.gridy;
            this.gbc.gridwidth = -1;
            JTextField[] jTextFieldArray = new JTextField[stringArray.length];
            for (n = 0; n < stringArray.length; ++n) {
                this.gbc.fill = 0;
                this.gbc.gridx = 0;
                this.gbc.weightx = 1.0;
                this.panel.add((Component)new JLabel(stringArray[n]), this.gbc);
                this.gbc.gridx = 1;
                this.gbc.fill = 2;
                this.gbc.weighty = 1.0;
                if (blArray[n]) {
                    jTextFieldArray[n] = new JTextField(20);
                } else {
                    jTextFieldArray[n] = new JPasswordField(20);
                    jTextFieldArray[n].requestFocusInWindow();
                }
                this.panel.add((Component)jTextFieldArray[n], this.gbc);
                ++this.gbc.gridy;
            }
            for (n = stringArray.length - 1; n > 0; --n) {
                jTextFieldArray[n].requestFocusInWindow();
            }
            JOptionPane jOptionPane = new JOptionPane(this.panel, 3, 2){

                @Override
                public void selectInitialValue() {
                }
            };
            JDialog jDialog = jOptionPane.createDialog(JCTermSwingFrame.this.term, string + ": " + string2);
            jDialog.setDefaultCloseOperation(2);
            jDialog.setVisible(true);
            Object object = jOptionPane.getValue();
            if (object != null && (Integer)object == 0) {
                String[] stringArray2 = new String[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray2[i] = jTextFieldArray[i].getText();
                }
                return stringArray2;
            }
            return null;
        }
    }
}

