/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jcterm.Configuration;
import com.jcraft.jcterm.ConfigurationRepository;
import com.jcraft.jcterm.Frame;
import com.jcraft.jcterm.JCTermSwing;
import com.jcraft.jcterm.JCTermSwingFrame;
import com.jcraft.jcterm.JSchSession;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class JCTermApplet
extends JApplet {
    JDesktopPane desktop = new JDesktopPane();
    private String configName = "default";

    @Override
    public void init() {
        int n;
        Object object;
        JCTermSwingFrame.resetCounter();
        String string = this.getParameter("jcterm.config.repository");
        if (string != null) {
            try {
                object = Class.forName(string);
                ConfigurationRepository configurationRepository = (ConfigurationRepository)((Class)object).newInstance();
                JCTermSwing.setCR(configurationRepository);
            }
            catch (Exception exception) {
                System.err.println("invalid jcterm.config.repository: " + string);
            }
        }
        if ((string = this.getParameter("jcterm.config.use_ssh_agent")) != null && string.equals("true")) {
            JSchSession.useSSHAgent(true);
        }
        if ((string = this.getParameter("jcterm.config.name")) != null) {
            this.configName = string;
        }
        object = JCTermSwing.getCR().load(this.configName);
        boolean bl = false;
        string = this.getParameter("jcterm.font_size");
        if (string != null) {
            try {
                int n2 = Integer.parseInt(string);
                if (((Configuration)object).font_size == Configuration.FONT_SIZE) {
                    ((Configuration)object).font_size = n2;
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("invalid jcterm.font_size: " + string);
            }
        }
        if ((string = this.getParameter("jcterm.destinations")) != null) {
            String[] stringArray = Configuration.parseDestinations(string);
            if ((stringArray = this.difference(stringArray, ((Configuration)object).destinations)).length > 0) {
                bl = true;
                for (n = stringArray.length - 1; n >= 0; --n) {
                    ((Configuration)object).addDestination(stringArray[n]);
                }
            }
        }
        if ((string = this.getParameter("jcterm.fg_bg")) != null) {
            String[] stringArray = Configuration.parseFgBg(string);
            if (stringArray != null) {
                if ((stringArray = this.difference(stringArray, ((Configuration)object).fg_bg)).length > 0) {
                    bl = true;
                    for (n = stringArray.length - 1; n >= 0; --n) {
                        ((Configuration)object).addFgBg(stringArray[n]);
                    }
                }
            } else {
                System.err.println("invalid jcterm.fg_bg: " + string);
            }
        }
        if (bl) {
            JCTermSwing.getCR().save((Configuration)object);
        }
        this.setVisible(true);
        if (Toolkit.getDefaultToolkit().getDesktopProperty("win.mdi.backgroundColor") != null) {
            this.desktop.setBackground((Color)Toolkit.getDefaultToolkit().getDesktopProperty("win.mdi.backgroundColor"));
        }
        Container container = this.getContentPane();
        container.add((Component)this.desktop, "Center");
        this.desktop.setVisible(true);
        JButton jButton = new JButton("New window");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JCTermApplet.this.openFrame(0, JCTermApplet.this.configName);
            }
        });
        container.add((Component)jButton, "North");
        jButton.setLocation(0, 0);
        jButton.setVisible(true);
        this.setFocusable(true);
    }

    @Override
    public void start() {
        this.requestFocus();
        this.setFocusable(true);
        this.openFrame(0, this.configName);
    }

    public void openFrame(int n, String string) {
        final JCTermSwing jCTermSwing = new JCTermSwing();
        JCTermSwingFrame jCTermSwingFrame = new JCTermSwingFrame();
        MyFrame myFrame = new MyFrame(jCTermSwingFrame);
        myFrame.setTitle("JCTerm");
        myFrame.setIconifiable(true);
        myFrame.getContentPane().add("Center", jCTermSwing);
        jCTermSwingFrame.setCloseOnExit(true);
        jCTermSwingFrame.setTerm(jCTermSwing);
        jCTermSwingFrame.setFrame(myFrame);
        myFrame.setJMenuBar(jCTermSwingFrame.getJMenuBar());
        myFrame.pack();
        this.desktop.add(myFrame);
        ComponentAdapter componentAdapter = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Component component = componentEvent.getComponent();
                Container container = ((JInternalFrame)component).getContentPane();
                int n = component.getWidth();
                int n2 = component.getHeight();
                int n3 = component.getWidth() - container.getWidth();
                int n4 = component.getHeight() - container.getHeight();
                jCTermSwing.setSize(n -= n3, n2 -= n4);
            }
        };
        myFrame.addComponentListener(componentAdapter);
        this.addKeyListener(jCTermSwing);
        jCTermSwing.setVisible(true);
        myFrame.setVisible(true);
        myFrame.setResizable(true);
        myFrame.setMaximizable(true);
        jCTermSwingFrame.applyConfig(this.configName);
        myFrame.setLocation((this.getWidth() - myFrame.getWidth()) / 2, (this.getHeight() - myFrame.getHeight()) / 2);
        jCTermSwingFrame.openSession();
    }

    private String[] difference(String[] stringArray, String[] stringArray2) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!string.equals(stringArray2[j])) continue;
                string = null;
                break;
            }
            if (string == null) continue;
            vector.addElement(string);
        }
        return vector.toArray(new String[0]);
    }

    class MyFrame
    extends JInternalFrame
    implements Frame {
        JCTermSwingFrame jctermsf;
        InternalFrameAdapter l = new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
                MyFrame.this.jctermsf.dispose_connection();
            }
        };

        MyFrame(JCTermSwingFrame jCTermSwingFrame) {
            this.jctermsf = jCTermSwingFrame;
            this.setClosable(true);
            this.addInternalFrameListener(this.l);
        }

        @Override
        public void openFrame(int n, String string) {
            JCTermApplet.this.openFrame(n, string);
        }
    }
}

