/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jcterm.Connection;
import com.jcraft.jcterm.JCTermAWT;
import com.jcraft.jcterm.JSchSession;
import com.jcraft.jcterm.Sftp;
import com.jcraft.jcterm.Splash;
import com.jcraft.jcterm.Term;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.ProxyHTTP;
import com.jcraft.jsch.ProxySOCKS5;
import com.jcraft.jsch.UserInfo;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Properties;

public class JCTermAWTFrame
extends Frame
implements ActionListener,
Runnable {
    private static final int SHELL = 0;
    private static final int SFTP = 1;
    private static final int EXEC = 2;
    private int mode = 0;
    int port = 22;
    private String xhost = "127.0.0.1";
    private int xport = 0;
    private boolean xforwarding = false;
    private String user = System.getProperty("user.name");
    private String host = "127.0.0.1";
    private String proxy_http_host = null;
    private int proxy_http_port = 0;
    private String proxy_socks5_host = null;
    private int proxy_socks5_port = 0;
    private JSchSession jschsession = null;
    private Proxy proxy = null;
    private int line_space = -2;
    private int compression = 0;
    private Splash splash = null;
    private JCTermAWT term = null;
    private Connection connection = null;
    private Thread thread = null;
    Dialog dialog = null;
    TextField textf = null;
    Button ok = null;
    Label label = null;

    public JCTermAWTFrame(String string) {
        super(string);
        this.enableEvents(8L);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        MenuBar menuBar = this.getMenuBar();
        this.setMenuBar(menuBar);
        this.term = new JCTermAWT();
        this.setSize(this.term.getTermWidth(), this.term.getTermHeight());
        this.add("Center", this.term);
        this.pack();
        this.term.setVisible(true);
        this.setVisible(true);
        this.term.initGraphics();
        this.setResizable(true);
        Insets insets = this.getInsets();
        int n = this.term.getTermWidth();
        int n2 = this.term.getTermHeight();
        this.setSize(n += insets.left + insets.right, n2 += insets.top + insets.bottom);
        this.setResizable(false);
    }

    public void kick() {
        this.thread = new Thread(this);
        this.thread.start();
    }

    @Override
    public void run() {
        block11: {
            if (this.thread != null) {
                try {
                    Object object;
                    MyUserInfo myUserInfo;
                    try {
                        myUserInfo = new MyUserInfo();
                        this.jschsession = JSchSession.getSession(this.user, null, this.host, this.port, myUserInfo, this.proxy);
                        object = new Properties();
                        if (this.compression == 0) {
                            ((Properties)object).put("compression.s2c", "none");
                            ((Properties)object).put("compression.c2s", "none");
                        } else {
                            ((Properties)object).put("compression.s2c", "zlib,none");
                            ((Properties)object).put("compression.c2s", "zlib,none");
                        }
                        this.jschsession.getSession().setConfig((Properties)object);
                        this.jschsession.getSession().rekey();
                    }
                    catch (Exception exception) {
                        break block11;
                    }
                    myUserInfo = null;
                    object = null;
                    InputStream inputStream = null;
                    if (this.mode == 0) {
                        myUserInfo = this.jschsession.getSession().openChannel("shell");
                        if (this.xforwarding) {
                            this.jschsession.getSession().setX11Host(this.xhost);
                            this.jschsession.getSession().setX11Port(this.xport + 6000);
                            myUserInfo.setXForwarding(true);
                        }
                        object = myUserInfo.getOutputStream();
                        inputStream = myUserInfo.getInputStream();
                        myUserInfo.connect();
                    } else if (this.mode == 1) {
                        object = new PipedOutputStream();
                        inputStream = new PipedInputStream();
                        myUserInfo = this.jschsession.getSession().openChannel("sftp");
                        myUserInfo.connect();
                        new Sftp((ChannelSftp)myUserInfo, new PipedInputStream((PipedOutputStream)object), new PipedOutputStream((PipedInputStream)inputStream)).kick();
                    }
                    Properties properties = object;
                    final PipedInputStream pipedInputStream = inputStream;
                    MyUserInfo myUserInfo2 = myUserInfo;
                    this.connection = new Connection((OutputStream)((Object)properties), (Channel)myUserInfo2){
                        final /* synthetic */ OutputStream val$fout;
                        final /* synthetic */ Channel val$fchannel;
                        {
                            this.val$fout = outputStream;
                            this.val$fchannel = channel;
                        }

                        @Override
                        public InputStream getInputStream() {
                            return pipedInputStream;
                        }

                        @Override
                        public OutputStream getOutputStream() {
                            return this.val$fout;
                        }

                        @Override
                        public void requestResize(Term term) {
                            if (this.val$fchannel instanceof ChannelShell) {
                                int n = term.getColumnCount();
                                int n2 = term.getRowCount();
                                ((ChannelShell)this.val$fchannel).setPtySize(n, n2, n * term.getCharWidth(), n2 * term.getCharHeight());
                            }
                        }

                        @Override
                        public void close() {
                            this.val$fchannel.disconnect();
                        }
                    };
                    this.setTitle(this.user + "@" + this.host + (this.port != 22 ? new Integer(this.port).toString() : ""));
                    this.term.requestFocus();
                    this.term.start(this.connection);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.setTitle("JCTerm");
        this.thread = null;
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void setProxyHttp(String string, int n) {
        this.proxy_http_host = string;
        this.proxy_http_port = n;
        this.proxy = this.proxy_http_host != null && this.proxy_http_port != 0 ? new ProxyHTTP(this.proxy_http_host, this.proxy_http_port) : null;
    }

    public String getProxyHttpHost() {
        return this.proxy_http_host;
    }

    public int getProxyHttpPort() {
        return this.proxy_http_port;
    }

    public void setProxySOCKS5(String string, int n) {
        this.proxy_socks5_host = string;
        this.proxy_socks5_port = n;
        this.proxy = this.proxy_socks5_host != null && this.proxy_socks5_port != 0 ? new ProxySOCKS5(this.proxy_socks5_host, this.proxy_socks5_port) : null;
    }

    public String getProxySOCKS5Host() {
        return this.proxy_socks5_host;
    }

    public int getProxySOCKS5Port() {
        return this.proxy_socks5_port;
    }

    public void setSplash(Splash splash) {
        this.splash = splash;
    }

    public void setXHost(String string) {
        this.xhost = string;
    }

    public void setXPort(int n) {
        this.xport = n;
    }

    public void setXForwarding(boolean bl) {
        this.xforwarding = bl;
    }

    public void setLineSpace(int n) {
        this.line_space = n;
    }

    public void setCompression(int n) {
        if (n < 0 || 9 < n) {
            return;
        }
        this.compression = n;
    }

    public int getCompression() {
        return this.compression;
    }

    public void setUserHost(String string) {
        try {
            String string2 = string.substring(0, string.indexOf(64));
            String string3 = string.substring(string.indexOf(64) + 1);
            this.user = string2;
            this.host = string3;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void openSession() {
        this.kick();
    }

    public void setPortForwardingL(int n, String string, int n2) {
        if (this.jschsession == null) {
            return;
        }
        try {
            this.jschsession.getSession().setPortForwardingL(n, string, n2);
        }
        catch (JSchException jSchException) {
            // empty catch block
        }
    }

    public void setPortForwardingR(int n, String string, int n2) {
        if (this.jschsession == null) {
            return;
        }
        try {
            this.jschsession.getSession().setPortForwardingR(n, string, n2);
        }
        catch (JSchException jSchException) {
            // empty catch block
        }
    }

    private Dialog getDialog() {
        if (this.dialog == null) {
            this.dialog = new Dialog(new Frame(), "", true);
            this.ok = new Button("OK");
            Button button = new Button("CANCEL");
            this.textf = new TextField(20);
            this.dialog.setLayout(new FlowLayout());
            this.dialog.setLocation(100, 50);
            this.ok.addActionListener(this);
            button.addActionListener(this);
            this.dialog.add(this.textf);
            this.dialog.add(this.ok);
            this.dialog.add(button);
            this.dialog.pack();
        }
        this.textf.setEchoCharacter('\u0000');
        return this.dialog;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block47: {
            String string = actionEvent.getActionCommand();
            if (string.equals("Open SHELL Session...") || string.equals("Open SFTP Session...")) {
                if (this.thread == null) {
                    if (string.equals("Open SHELL Session...")) {
                        this.mode = 0;
                    } else if (string.equals("Open SFTP Session...")) {
                        this.mode = 1;
                    }
                    while (true) {
                        InputDialog inputDialog = new InputDialog("Enter username@hostname", "", false);
                        try {
                            String string2 = inputDialog.getText();
                            if (string2 == null) {
                                return;
                            }
                            String string3 = string2.substring(0, string2.indexOf(64));
                            if ((string2 = string2.substring(string2.indexOf(64) + 1)) == null || string2.length() == 0) {
                                return;
                            }
                            this.user = string3;
                            this.host = string2;
                            this.openSession();
                            return;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                        break;
                    }
                }
            } else if (string.equals("HTTP...")) {
                String string4 = this.getProxyHttpHost();
                int n = this.getProxyHttpPort();
                InputDialog inputDialog = new InputDialog("HTTP proxy server (hostname:port)", string4 != null && n != 0 ? string4 + ":" + n : "", false);
                String string5 = inputDialog.getText();
                if (string5 == null) {
                    return;
                }
                if (string5.length() == 0) {
                    this.setProxyHttp(null, 0);
                    return;
                }
                try {
                    string4 = string5.substring(0, string5.indexOf(58));
                    n = Integer.parseInt(string5.substring(string5.indexOf(58) + 1));
                    if (string4 != null) {
                        this.setProxyHttp(string4, n);
                    }
                }
                catch (Exception exception) {}
            } else if (string.equals("SOCKS5...")) {
                String string6 = this.getProxySOCKS5Host();
                int n = this.getProxySOCKS5Port();
                InputDialog inputDialog = new InputDialog("SOCKS5 server (hostname:1080)", string6 != null && n != 0 ? string6 + ":" + n : "", false);
                String string7 = this.textf.getText();
                if (string7 == null) {
                    return;
                }
                if (string7.length() == 0) {
                    this.setProxySOCKS5(null, 0);
                    return;
                }
                try {
                    string6 = string7.substring(0, string7.indexOf(58));
                    n = Integer.parseInt(string7.substring(string7.indexOf(58) + 1));
                    if (string6 != null) {
                        this.setProxySOCKS5(string6, n);
                    }
                }
                catch (Exception exception) {}
            } else if (string.equals("About...")) {
                MessageDialog messageDialog = new MessageDialog("About...", JCTermAWT.COPYRIGHT);
            } else if (string.equals("Compression...")) {
                InputDialog inputDialog = new InputDialog("Compression level(0-9)", new Integer(this.compression).toString(), false);
                String string8 = inputDialog.getText();
                try {
                    if (string8 != null) {
                        this.compression = Integer.parseInt(string8);
                    }
                }
                catch (Exception exception) {}
            } else if (string.equals("Line Space...")) {
                InputDialog inputDialog = new InputDialog("Line Space", new Integer(this.line_space).toString(), false);
                String string9 = inputDialog.getText();
                try {
                    if (string9 != null) {
                        this.setLineSpace(Integer.parseInt(string9));
                    }
                }
                catch (Exception exception) {}
            } else if (string.equals("Local Port...") || string.equals("Remote Port...")) {
                if (this.jschsession == null) {
                    return;
                }
                try {
                    String string10 = "";
                    string10 = string.equals("Local Port...") ? string10 + "Local port forwarding" : string10 + "remote port forwarding";
                    string10 = string10 + "(port:host:hostport)";
                    InputDialog inputDialog = new InputDialog(string10, "", false);
                    String string11 = inputDialog.getText();
                    if (string11 == null) {
                        return;
                    }
                    int n = Integer.parseInt(string11.substring(0, string11.indexOf(58)));
                    string11 = string11.substring(string11.indexOf(58) + 1);
                    String string12 = string11.substring(0, string11.indexOf(58));
                    int n2 = Integer.parseInt(string11.substring(string11.indexOf(58) + 1));
                    if (string.equals("Local Port...")) {
                        this.setPortForwardingL(n, string12, n2);
                        break block47;
                    }
                    this.setPortForwardingR(n, string12, n2);
                }
                catch (Exception exception) {}
            } else if (string.equals("Quit")) {
                this.quit();
            } else if (string.equals("CANCEL")) {
                this.dialog.setVisible(false);
            }
        }
    }

    @Override
    public MenuBar getMenuBar() {
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu("File");
        MenuItem menuItem = new MenuItem("Open SHELL Session...");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("Open SFTP Session...");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("Quit");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new Menu("Proxy");
        menuItem = new MenuItem("HTTP...");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("SOCKS5...");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new Menu("PortForwarding");
        menuItem = new MenuItem("Local Port...");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menuItem = new MenuItem("Remote Port...");
        menuItem.addActionListener(this);
        menu.add(menuItem);
        menu = new Menu("Etc");
        menuItem = new MenuItem("Compression...");
        menuItem.addActionListener(this);
        menuItem.setActionCommand("Compression...");
        menu.add(menuItem);
        menuBar.add(menu);
        menu = new Menu("Help");
        menuItem = new MenuItem("About...");
        menuItem.addActionListener(this);
        menuItem.setActionCommand("About...");
        menu.add(menuItem);
        menuBar.add(menu);
        return menuBar;
    }

    public void quit() {
        this.thread = null;
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    public void setTerm(JCTermAWT jCTermAWT) {
        this.term = jCTermAWT;
    }

    public Term getTerm() {
        return this.term;
    }

    public static void main(String[] stringArray) {
        JCTermAWTFrame jCTermAWTFrame = new JCTermAWTFrame("JCTerm");
        jCTermAWTFrame.setVisible(true);
        jCTermAWTFrame.setResizable(true);
    }

    class MessageDialog
    implements ActionListener {
        Dialog dialog = null;

        MessageDialog(String string, String string2) {
            this.dialog = new Dialog(new Frame(), string, true);
            Button button = new Button("OK");
            this.dialog.setLayout(new FlowLayout());
            this.dialog.setLocation(100, 50);
            button.addActionListener(this);
            TextArea textArea = new TextArea(string2);
            this.dialog.add(textArea);
            this.dialog.add(button);
            this.dialog.pack();
            this.dialog.setVisible(true);
        }

        boolean isVisible() {
            return this.dialog.isVisible();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            this.dialog.setVisible(false);
        }
    }

    class PromptDialog
    implements ActionListener {
        boolean result = false;
        Dialog dialog = null;

        PromptDialog(String string, String string2) {
            this.dialog = new Dialog(new Frame(), string, true);
            Button button = new Button("YES");
            Button button2 = new Button("NO");
            this.dialog.setLayout(new FlowLayout());
            this.dialog.setLocation(100, 50);
            button.addActionListener(this);
            button2.addActionListener(this);
            TextArea textArea = new TextArea(string2);
            this.dialog.add(textArea);
            this.dialog.add(button);
            this.dialog.add(button2);
            this.dialog.pack();
            this.dialog.setVisible(true);
        }

        boolean isVisible() {
            return this.dialog.isVisible();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("YES")) {
                this.result = true;
            }
            this.dialog.setVisible(false);
        }
    }

    class InputDialog
    implements ActionListener {
        String result = null;
        Dialog dialog = null;
        TextField textf = null;

        InputDialog(String string, String string2, boolean bl) {
            this.dialog = new Dialog(new Frame(), string, true);
            Button button = new Button("OK");
            Button button2 = new Button("CANCEL");
            this.textf = new TextField(20);
            this.textf.setText(string2);
            if (bl) {
                this.textf.setEchoCharacter('*');
            }
            this.dialog.setLayout(new FlowLayout());
            this.dialog.setLocation(100, 50);
            button.addActionListener(this);
            button2.addActionListener(this);
            this.dialog.add(this.textf);
            this.dialog.add(button);
            this.dialog.add(button2);
            this.dialog.pack();
            this.dialog.setVisible(true);
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (this.dialog.isVisible());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("OK")) {
                this.result = this.textf.getText();
            } else if (string.equals("CANCEL")) {
                // empty if block
            }
            this.dialog.setVisible(false);
        }

        String getText() {
            return this.result;
        }
    }

    public class MyUserInfo
    implements UserInfo {
        String passwd = null;
        String passphrase = null;

        public boolean promptYesNo(String string) {
            PromptDialog promptDialog = new PromptDialog("Warning", string);
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (promptDialog.isVisible());
            return promptDialog.result;
        }

        public String getPassword() {
            return this.passwd;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public boolean promptPassword(String string) {
            InputDialog inputDialog = new InputDialog(string, "", true);
            this.passwd = inputDialog.getText();
            return this.passwd != null;
        }

        public boolean promptPassphrase(String string) {
            InputDialog inputDialog = new InputDialog(string, "", true);
            this.passphrase = inputDialog.getText();
            return this.passphrase != null;
        }

        public void showMessage(String string) {
            MessageDialog messageDialog = new MessageDialog("", string);
        }
    }
}

