/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jcterm.Connection;
import com.jcraft.jcterm.Emulator;
import com.jcraft.jcterm.EmulatorVT100;
import com.jcraft.jcterm.Splash;
import com.jcraft.jcterm.Term;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.InputStream;
import java.io.OutputStream;

public class JCTermAWT
extends Panel
implements KeyListener,
Term {
    static String COPYRIGHT = "JCTerm 0.0.11\nCopyright (C) 2002,2007 ymnk<ymnk@jcraft.com>, JCraft,Inc.\nOfficial Homepage: http://www.jcraft.com/jcterm/\nThis software is licensed under GNU LGPL.";
    private OutputStream out;
    private InputStream in;
    Emulator emulator = null;
    Connection connection = null;
    private Image img;
    private Graphics cursor_graphics;
    private Graphics graphics;
    private Color defaultbground = Color.black;
    private Color defaultfground = Color.white;
    private Color bground = Color.black;
    private Color fground = Color.white;
    private Component term_area = null;
    private Font font;
    private boolean bold = false;
    private boolean underline = false;
    private boolean reverse = false;
    private int term_width = 80;
    private int term_height = 24;
    private int x = 0;
    private int y = 0;
    private int descent = 0;
    private int char_width;
    private int char_height;
    private boolean antialiasing = true;
    private int line_space = -2;
    private int compression = 0;
    private Splash splash = null;
    private final Object[] colors = new Object[]{Color.black, Color.red, Color.green, Color.yellow, Color.blue, Color.magenta, Color.cyan, Color.white};
    private Thread thread = null;
    byte[] obuffer = new byte[3];

    public JCTermAWT() {
        this.enableEvents(8L);
    }

    private void setFont(String string) {
        this.font = Font.decode(string);
        Image image = this.createImage(1, 1);
        Graphics graphics = image.getGraphics();
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        this.descent = fontMetrics.getDescent();
        this.char_width = fontMetrics.charWidth('@');
        this.char_height = fontMetrics.getHeight() + this.line_space * 2;
        image.flush();
        graphics.dispose();
    }

    void initGraphics() {
        this.setFont("Monospaced-14");
        this.img = this.createImage(this.getTermWidth(), this.getTermHeight());
        this.graphics = this.img.getGraphics();
        this.graphics.setFont(this.font);
        if (this.splash != null) {
            this.splash.draw(this.img, this.getTermWidth(), this.getTermHeight());
        } else {
            this.clear();
        }
        this.cursor_graphics = this.img.getGraphics();
        this.cursor_graphics.setColor(this.getForeGround());
        this.cursor_graphics.setXORMode(this.getBackGround());
        this.term_area = this;
        JCTermAWT jCTermAWT = this;
        jCTermAWT.setSize(this.getTermWidth(), this.getTermHeight());
        jCTermAWT.setFocusable(true);
    }

    public void setFrame(Component component) {
        this.term_area = component;
    }

    @Override
    public void start(Connection connection) {
        this.connection = connection;
        this.in = connection.getInputStream();
        this.out = connection.getOutputStream();
        this.emulator = new EmulatorVT100(this, this.in);
        this.emulator.reset();
        this.emulator.start();
        if (this.splash != null) {
            this.splash.draw(this.img, this.getTermWidth(), this.getTermHeight());
        } else {
            this.clear();
        }
        this.redraw(0, 0, this.getTermWidth(), this.getTermHeight());
    }

    @Override
    public void update(Graphics graphics) {
        if (this.img == null) {
            this.initGraphics();
        }
        graphics.drawImage(this.img, 0, 0, this.term_area);
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.img == null) {
            this.initGraphics();
        }
        graphics.drawImage(this.img, 0, 0, this.term_area);
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        int n = keyEvent.getID();
        if (n == 401) {
            this.keyPressed(keyEvent);
        } else if (n != 402 && n == 400) {
            this.keyTyped(keyEvent);
        }
        keyEvent.consume();
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        byte[] byArray = null;
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 20: {
                return;
            }
            case 10: {
                byArray = this.emulator.getCodeENTER();
                break;
            }
            case 38: {
                byArray = this.emulator.getCodeUP();
                break;
            }
            case 40: {
                byArray = this.emulator.getCodeDOWN();
                break;
            }
            case 39: {
                byArray = this.emulator.getCodeRIGHT();
                break;
            }
            case 37: {
                byArray = this.emulator.getCodeLEFT();
                break;
            }
            case 112: {
                byArray = this.emulator.getCodeF1();
                break;
            }
            case 113: {
                byArray = this.emulator.getCodeF2();
                break;
            }
            case 114: {
                byArray = this.emulator.getCodeF3();
                break;
            }
            case 115: {
                byArray = this.emulator.getCodeF4();
                break;
            }
            case 116: {
                byArray = this.emulator.getCodeF5();
                break;
            }
            case 117: {
                byArray = this.emulator.getCodeF6();
                break;
            }
            case 118: {
                byArray = this.emulator.getCodeF7();
                break;
            }
            case 119: {
                byArray = this.emulator.getCodeF8();
                break;
            }
            case 120: {
                byArray = this.emulator.getCodeF9();
                break;
            }
            case 121: {
                byArray = this.emulator.getCodeF10();
                break;
            }
            case 9: {
                byArray = this.emulator.getCodeTAB();
            }
        }
        if (byArray != null) {
            try {
                this.out.write(byArray, 0, byArray.length);
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
        char c = keyEvent.getKeyChar();
        if ((c & 0xFF00) == 0) {
            this.obuffer[0] = (byte)keyEvent.getKeyChar();
            try {
                this.out.write(this.obuffer, 0, 1);
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if ((c & 0xFF00) != 0) {
            char[] cArray = new char[]{c};
            try {
                byte[] byArray = new String(cArray).getBytes("EUC-JP");
                this.out.write(byArray, 0, byArray.length);
                this.out.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public int getTermWidth() {
        return this.char_width * this.term_width;
    }

    @Override
    public int getTermHeight() {
        return this.char_height * this.term_height;
    }

    @Override
    public int getCharWidth() {
        return this.char_width;
    }

    @Override
    public int getCharHeight() {
        return this.char_height;
    }

    @Override
    public int getColumnCount() {
        return this.term_width;
    }

    @Override
    public int getRowCount() {
        return this.term_height;
    }

    @Override
    public void clear() {
        this.graphics.setColor(this.getBackGround());
        this.graphics.fillRect(0, 0, this.char_width * this.term_width, this.char_height * this.term_height);
        this.graphics.setColor(this.getForeGround());
    }

    @Override
    public void setCursor(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    @Override
    public void draw_cursor() {
        this.cursor_graphics.fillRect(this.x, this.y - this.char_height, this.char_width, this.char_height);
        this.repaint(this.x, this.y - this.char_height, this.char_width, this.char_height);
    }

    @Override
    public void redraw(int n, int n2, int n3, int n4) {
        this.repaint(n, n2, n3, n4);
    }

    @Override
    public void clear_area(int n, int n2, int n3, int n4) {
        this.graphics.setColor(this.getBackGround());
        this.graphics.fillRect(n, n2, n3 - n, n4 - n2);
        this.graphics.setColor(this.getForeGround());
    }

    @Override
    public void scroll_area(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.copyArea(n, n2, n3, n4, n5, n6);
    }

    @Override
    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.graphics.drawBytes(byArray, n, n2, n3, n4 - (this.descent + this.line_space));
        if (this.bold) {
            this.graphics.drawBytes(byArray, n, n2, n3 + 1, n4 - (this.descent + this.line_space));
        }
        if (this.underline) {
            // empty if block
        }
    }

    @Override
    public void drawString(String string, int n, int n2) {
        this.graphics.drawString(string, n, n2 - (this.descent + this.line_space));
        if (this.bold) {
            this.graphics.drawString(string, n + 1, n2 - (this.descent + this.line_space));
        }
        if (this.underline) {
            // empty if block
        }
    }

    @Override
    public void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    public void setSplash(Splash splash) {
        this.splash = splash;
    }

    public void setLineSpace(int n) {
        this.line_space = n;
    }

    public void setCompression(int n) {
        if (n < 0 || 9 < n) {
            return;
        }
        this.compression = n;
    }

    public int getCompression() {
        return this.compression;
    }

    private Color toColor(Object object) {
        if (object instanceof String) {
            return Color.getColor((String)object);
        }
        if (object instanceof Color) {
            return (Color)object;
        }
        return Color.white;
    }

    @Override
    public void setDefaultForeGround(Object object) {
        this.defaultfground = this.toColor(object);
    }

    @Override
    public void setDefaultBackGround(Object object) {
        this.defaultbground = this.toColor(object);
    }

    @Override
    public void setForeGround(Object object) {
        this.fground = this.toColor(object);
        this.graphics.setColor(this.getForeGround());
    }

    @Override
    public void setBackGround(Object object) {
        this.bground = this.toColor(object);
    }

    private Color getForeGround() {
        if (this.reverse) {
            return this.bground;
        }
        return this.fground;
    }

    private Color getBackGround() {
        if (this.reverse) {
            return this.fground;
        }
        return this.bground;
    }

    @Override
    public Object getColor(int n) {
        if (this.colors == null || n < 0 || this.colors.length <= n) {
            return null;
        }
        return this.colors[n];
    }

    @Override
    public void setBold() {
        this.bold = true;
    }

    @Override
    public void setUnderline() {
        this.underline = true;
    }

    @Override
    public void setReverse() {
        this.reverse = true;
        if (this.graphics != null) {
            this.graphics.setColor(this.getForeGround());
        }
    }

    @Override
    public void resetAllAttributes() {
        this.bold = false;
        this.underline = false;
        this.reverse = false;
        this.bground = this.defaultbground;
        this.fground = this.defaultfground;
        if (this.graphics != null) {
            this.graphics.setColor(this.getForeGround());
        }
    }
}

