/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jcterm.Configuration;
import com.jcraft.jcterm.ConfigurationRepository;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class ConfigurationRepositoryFS
implements ConfigurationRepository {
    private File ssh_home = new File(System.getProperty("user.home"), ".ssh");
    private File jcterm_prop = new File(this.ssh_home, "jcterm.properties");

    @Override
    public Configuration load(String string) {
        Configuration configuration = new Configuration();
        configuration.name = string;
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.jcterm_prop);
            properties.load(fileInputStream);
            String string2 = "jcterm." + string + ".font_size";
            if (properties.get(string2) != null) {
                try {
                    configuration.font_size = Integer.parseInt((String)properties.get(string2));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                string2 = "jcterm." + string + ".fg_bg";
                if (properties.get(string2) != null) {
                    configuration.fg_bg = ((String)properties.get(string2)).split(",");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                string2 = "jcterm." + string + ".destination";
                if (properties.get(string2) != null) {
                    configuration.destinations = ((String)properties.get(string2)).split(",");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((InputStream)fileInputStream).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configuration;
    }

    @Override
    public void save(Configuration configuration) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.jcterm_prop);
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = configuration.name;
        properties.setProperty("jcterm." + string + ".destination", this.join(configuration.destinations));
        properties.setProperty("jcterm." + string + ".font_size", new Integer(configuration.font_size).toString());
        properties.setProperty("jcterm." + string + ".fg_bg", this.join(configuration.fg_bg));
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.jcterm_prop);
            properties.store(fileOutputStream, "");
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    String join(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i + 1 >= stringArray.length) continue;
            stringBuilder.append(",");
        }
        return stringBuilder.toString();
    }
}

