/*
 * Decompiled with CFR 0.152.
 */
package linoleum.console;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.MalformedURLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class JTop
extends JPanel {
    private static final long serialVersionUID = -1499762160973870696L;
    private MBeanServerConnection server;
    private ThreadMXBean tmbean;
    private MyTableModel tmodel = new MyTableModel();
    private final StatusBar statusBar;

    public JTop() {
        super(new GridBagLayout());
        JTable jTable = new JTable(this.tmodel);
        jTable.setPreferredScrollableViewportSize(new Dimension(500, 300));
        jTable.setDefaultRenderer(Double.class, new DoubleRenderer());
        jTable.setIntercellSpacing(new Dimension(6, 3));
        jTable.setRowHeight(jTable.getRowHeight() + 4);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)jScrollPane, gridBagConstraints);
        this.statusBar = new StatusBar(false);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        this.add((Component)this.statusBar, gridBagConstraints2);
    }

    public void setMBeanServerConnection(MBeanServerConnection mBeanServerConnection) {
        this.server = mBeanServerConnection;
        try {
            this.tmbean = ManagementFactory.newPlatformMXBeanProxy(this.server, "java.lang:type=Threading", ThreadMXBean.class);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (!this.tmbean.isThreadCpuTimeSupported()) {
            this.statusBar.setMessage("Monitored VM does not support thread CPU time measurement");
        } else {
            try {
                this.tmbean.setThreadCpuTimeEnabled(true);
            }
            catch (SecurityException securityException) {
                this.statusBar.setMessage("Monitored VM does not have permission for enabling thread cpu time measurement");
            }
        }
    }

    private List<Map.Entry<Long, ThreadInfo>> getThreadList() {
        long[] lArray = this.tmbean.getAllThreadIds();
        ThreadInfo[] threadInfoArray = this.tmbean.getThreadInfo(lArray);
        TreeMap<Long, ThreadInfo> treeMap = new TreeMap<Long, ThreadInfo>();
        for (int i = 0; i < lArray.length; ++i) {
            long l = this.tmbean.getThreadCpuTime(lArray[i]);
            if (l == -1L || threadInfoArray[i] == null) continue;
            treeMap.put(new Long(l), threadInfoArray[i]);
        }
        Set set = treeMap.entrySet();
        ArrayList<Map.Entry<Long, ThreadInfo>> arrayList = new ArrayList<Map.Entry<Long, ThreadInfo>>(set);
        Collections.reverse(arrayList);
        return arrayList;
    }

    public SwingWorker<?, ?> newSwingWorker() {
        return new Worker(this.tmodel);
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2;
        if (stringArray.length != 1) {
            JTop.usage();
        }
        if ((stringArray2 = stringArray[0].split(":")).length != 2) {
            JTop.usage();
        }
        String string = stringArray2[0];
        int n = -1;
        try {
            n = Integer.parseInt(stringArray2[1]);
        }
        catch (NumberFormatException numberFormatException) {
            JTop.usage();
        }
        if (n < 0) {
            JTop.usage();
        }
        final JTop jTop = new JTop();
        MBeanServerConnection mBeanServerConnection = JTop.connect(string, n);
        jTop.setMBeanServerConnection(mBeanServerConnection);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                jTop.newSwingWorker().execute();
            }
        };
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                JTop.createAndShowGUI(jTop);
            }
        });
        Timer timer = new Timer("JTop Sampling thread");
        timer.schedule(timerTask, 0L, 2000L);
    }

    private static MBeanServerConnection connect(String string, int n) {
        String string2 = "/jndi/rmi://" + string + ":" + n + "/jmxrmi";
        MBeanServerConnection mBeanServerConnection = null;
        try {
            JMXServiceURL jMXServiceURL = new JMXServiceURL("rmi", "", 0, string2);
            JMXConnector jMXConnector = JMXConnectorFactory.connect(jMXServiceURL);
            mBeanServerConnection = jMXConnector.getMBeanServerConnection();
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            System.err.println("\nCommunication error: " + iOException.getMessage());
            System.exit(1);
        }
        return mBeanServerConnection;
    }

    private static void usage() {
        System.out.println("Usage: java JTop <hostname>:<port>");
        System.exit(1);
    }

    private static void createAndShowGUI(JPanel jPanel) {
        JFrame jFrame = new JFrame("JTop");
        jFrame.setDefaultCloseOperation(3);
        JComponent jComponent = (JComponent)jFrame.getContentPane();
        jComponent.add((Component)jPanel, "Center");
        jComponent.setOpaque(true);
        jComponent.setBorder(new EmptyBorder(12, 12, 12, 12));
        jFrame.setContentPane(jComponent);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    class Worker
    extends SwingWorker<List<Map.Entry<Long, ThreadInfo>>, Object> {
        private MyTableModel tmodel;

        Worker(MyTableModel myTableModel) {
            this.tmodel = myTableModel;
        }

        @Override
        public List<Map.Entry<Long, ThreadInfo>> doInBackground() {
            return JTop.this.getThreadList();
        }

        @Override
        protected void done() {
            try {
                this.tmodel.setThreadList((List)this.get());
                this.tmodel.fireTableDataChanged();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    class DoubleRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1704639497162584382L;
        NumberFormat formatter;

        public DoubleRenderer() {
            this.setHorizontalAlignment(4);
        }

        @Override
        public void setValue(Object object) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
                this.formatter.setMinimumFractionDigits(4);
            }
            this.setText(object == null ? "" : this.formatter.format(object));
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -7877310288576779514L;
        private String[] columnNames = new String[]{"ThreadName", "CPU(sec)", "State"};
        private List<Map.Entry<Long, ThreadInfo>> threadList = Collections.emptyList();

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.threadList.size();
        }

        @Override
        public String getColumnName(int n) {
            return this.columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Map.Entry<Long, ThreadInfo> entry = this.threadList.get(n);
            switch (n2) {
                case 0: {
                    return entry.getValue().getThreadName();
                }
                case 1: {
                    long l = entry.getKey();
                    double d = l / 1000000000L;
                    return new Double(d);
                }
                case 2: {
                    return entry.getValue().getThreadState();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        void setThreadList(List<Map.Entry<Long, ThreadInfo>> list) {
            this.threadList = list;
        }
    }

    private static class StatusBar
    extends JPanel {
        private static final long serialVersionUID = -6483392381797633018L;
        private final JLabel statusText = new JLabel();

        public StatusBar(boolean bl) {
            super(new GridLayout(1, 1));
            this.statusText.setVisible(bl);
            this.add(this.statusText);
        }

        @Override
        public Dimension getMaximumSize() {
            Dimension dimension = super.getMaximumSize();
            Dimension dimension2 = this.getMinimumSize();
            return new Dimension(dimension.width, dimension2.height);
        }

        public void setMessage(String string) {
            this.statusText.setText(string);
            this.statusText.setVisible(true);
        }
    }
}

