/*
 * Decompiled with CFR 0.152.
 */
package linoleum.console;

import java.awt.Component;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import javax.swing.ImageIcon;
import linoleum.application.Frame;
import sun.tools.jconsole.LocalVirtualMachine;
import sun.tools.jconsole.ProxyClient;
import sun.tools.jconsole.VMPanel;

public class JConsole
extends Frame {
    private final ProxyClient client = this.getProxyClient();
    private VMPanel panel;

    public JConsole() {
        this.setClosable(true);
        this.setIconifiable(true);
        this.setMaximizable(true);
        this.setResizable(true);
        this.setSize(640, 480);
        this.setTitle("JConsole");
        this.setFrameIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("JavaCup16.png")));
        this.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("JavaCup24.png")));
    }

    private ProxyClient getProxyClient() {
        String string = ManagementFactory.getRuntimeMXBean().getName();
        string = string.substring(0, string.indexOf("@"));
        LocalVirtualMachine localVirtualMachine = LocalVirtualMachine.getAllVirtualMachines().get(Integer.valueOf(string));
        try {
            return ProxyClient.getProxyClient(localVirtualMachine);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private VMPanel getPanel(ProxyClient proxyClient, int n) {
        try {
            Constructor constructor = VMPanel.class.getDeclaredConstructor(ProxyClient.class, Integer.TYPE);
            constructor.setAccessible(true);
            return (VMPanel)constructor.newInstance(proxyClient, n);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
            return null;
        }
    }

    private void setShouldUseSSL(boolean bl) {
        try {
            Field field = VMPanel.class.getDeclaredField("shouldUseSSL");
            field.setAccessible(true);
            field.setBoolean(this.panel, bl);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            reflectiveOperationException.printStackTrace();
        }
    }

    public void open() {
        this.panel = this.getPanel(this.client, 4000);
        this.getContentPane().add((Component)this.panel, "Center");
        this.setShouldUseSSL(false);
        this.panel.connect();
    }

    public void close() {
        this.panel.disconnect();
        this.panel.cleanUp();
        this.getContentPane().remove(this.panel);
        this.panel = null;
    }

    static {
        System.setProperty("swing.defaultlaf", "javax.swing.plaf.metal.MetalLookAndFeel");
    }
}

