/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Rumbler;
import net.java.games.input.Version;

public class RumbleTest {
    public RumbleTest() {
        ControllerEnvironment ca = ControllerEnvironment.getDefaultEnvironment();
        System.out.println("JInput version: " + Version.getVersion());
        Controller[] controllers = ca.getControllers();
        for (int i = 0; i < controllers.length; ++i) {
            System.out.println("Scanning " + controllers[i].getName());
            Rumbler[] rumblers = controllers[i].getRumblers();
            System.out.println("Found " + rumblers.length + " rumblers");
            for (int j = 0; j < rumblers.length; ++j) {
                long startTime;
                System.out.println("Rumbler " + rumblers[j].getAxisName() + " on axis " + String.valueOf(rumblers[j].getAxisIdentifier()));
                System.out.println("Rumbling with intensity: 0.5");
                rumblers[j].rumble(0.5f);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Rumbling with intensity: 1.0");
                rumblers[j].rumble(1.0f);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Fading rumble to -1");
                for (float k = 1.0f; k > -1.0f; k -= (float)(System.currentTimeMillis() - startTime) / 1000.0f) {
                    startTime = System.currentTimeMillis();
                    rumblers[j].rumble(k);
                    try {
                        Thread.sleep(1L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Rumbling with intensity: 0.0");
                rumblers[j].rumble(0.0f);
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        new RumbleTest();
    }
}

