/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Version;

public final class ControllerReadTest
extends JFrame {
    private static final long serialVersionUID = -7129976919159465311L;
    static final long HEARTBEATMS = 100L;
    transient List<ControllerWindow> controllers = new ArrayList<ControllerWindow>();

    public ControllerReadTest() {
        super("Controller Read Test. Version: " + Version.getVersion());
        ControllerEnvironment ce = ControllerEnvironment.getDefaultEnvironment();
        Controller[] ca = ce.getControllers();
        for (int i = 0; i < ca.length; ++i) {
            this.makeController(ca[i]);
        }
        new Thread(() -> {
            try {
                while (true) {
                    Iterator<ControllerWindow> i = this.controllers.iterator();
                    while (i.hasNext()) {
                        try {
                            ControllerWindow cw = i.next();
                            cw.poll();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    Thread.sleep(100L);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }).start();
        this.pack();
        this.setSize(400, 400);
        this.setDefaultCloseOperation(3);
        this.setVisible(true);
    }

    private void makeController(Controller c) {
        Controller[] subControllers = c.getControllers();
        if (subControllers.length == 0) {
            this.createControllerWindow(c);
        } else {
            for (int i = 0; i < subControllers.length; ++i) {
                this.makeController(subControllers[i]);
            }
        }
    }

    private void createControllerWindow(Controller c) {
        this.controllers.add(new ControllerWindow(this, c));
    }

    public static void main(String[] args) {
        new ControllerReadTest().setVisible(true);
    }

    private static class ControllerWindow
    extends JFrame {
        private static final long serialVersionUID = 5812903945250431578L;
        transient Controller ca;
        transient List<AxisPanel> axisList = new ArrayList<AxisPanel>();
        boolean disabled = false;

        public ControllerWindow(JFrame frame, Controller ca) {
            super(ca.getName());
            this.setName(ca.getName());
            this.ca = ca;
            Container c = this.getContentPane();
            c.setLayout(new BorderLayout());
            Component[] components = ca.getComponents();
            System.out.println("Component count = " + components.length);
            if (components.length > 0) {
                int width = (int)Math.ceil(Math.sqrt(components.length));
                JPanel p = new JPanel();
                p.setLayout(new GridLayout(width, 0));
                for (int j = 0; j < components.length; ++j) {
                    this.addAxis(p, components[j]);
                }
                c.add((java.awt.Component)new JScrollPane(p), "Center");
            }
            this.setSize(400, 400);
            this.setLocation(50, 50);
            this.setVisible(true);
        }

        public boolean disabled() {
            return this.disabled;
        }

        private void setDisabled(boolean b) {
            this.disabled = b;
            if (!this.disabled) {
                this.setTitle(this.ca.getName());
                System.out.println(this.ca.getName() + " enabled");
            } else {
                this.setTitle(this.ca.getName() + " DISABLED!");
                System.out.println(this.ca.getName() + " disabled");
            }
            this.repaint();
        }

        private void addAxis(JPanel p, Component ax) {
            AxisPanel p2 = ax.isAnalog() ? new AnalogAxisPanel(ax) : (ax.getIdentifier() == Component.Identifier.Axis.POV ? new DigitalHatPanel(ax) : new DigitalAxisPanel(ax));
            p.add(p2);
            this.axisList.add(p2);
        }

        public void poll() {
            if (!this.ca.poll()) {
                if (!this.disabled()) {
                    this.setDisabled(true);
                }
                return;
            }
            if (this.disabled()) {
                this.setDisabled(false);
            }
            Iterator<AxisPanel> i = this.axisList.iterator();
            while (i.hasNext()) {
                try {
                    i.next().poll();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static class AnalogAxisPanel
    extends AxisPanel {
        private static final long serialVersionUID = -3220244985697453835L;
        JLabel analogState = new JLabel("<unread>");

        public AnalogAxisPanel(Component ax) {
            super(ax);
            this.add((java.awt.Component)this.analogState, "Center");
        }

        @Override
        protected void renderData() {
            String extra = "";
            if (this.getAxis().getDeadZone() >= Math.abs(this.data)) {
                extra = " (DEADZONE)";
            }
            this.analogState.setText(this.data + extra);
            this.analogState.repaint();
        }
    }

    private static class DigitalHatPanel
    extends AxisPanel {
        private static final long serialVersionUID = -3293100130201231029L;
        JLabel digitalState = new JLabel("<unread>");

        public DigitalHatPanel(Component ax) {
            super(ax);
            this.add((java.awt.Component)this.digitalState, "Center");
        }

        @Override
        protected void renderData() {
            if (this.data == 0.0f) {
                this.digitalState.setBackground(this.getBackground());
                this.digitalState.setText("OFF");
            } else if (this.data == 0.25f) {
                this.digitalState.setBackground(Color.green);
                this.digitalState.setText("UP");
            } else if (this.data == 0.375f) {
                this.digitalState.setBackground(Color.green);
                this.digitalState.setText("UP+RIGHT");
            } else if (this.data == 0.5f) {
                this.digitalState.setBackground(Color.green);
                this.digitalState.setText("RIGHT");
            } else if (this.data == 0.625f) {
                this.digitalState.setBackground(Color.green);
                this.digitalState.setText("DOWN+RIGHT");
            } else if (this.data == 0.75f) {
                this.digitalState.setBackground(Color.green);
                this.digitalState.setText("DOWN");
            } else if (this.data == 0.875f) {
                this.digitalState.setBackground(Color.green);
                this.digitalState.setText("DOWN+LEFT");
            } else if (this.data == 1.0f) {
                this.digitalState.setBackground(Color.green);
                this.digitalState.setText("LEFT");
            } else if (this.data == 0.125f) {
                this.digitalState.setBackground(Color.green);
                this.digitalState.setText("UP+LEFT");
            } else {
                this.digitalState.setBackground(Color.red);
                this.digitalState.setText("ERR:" + this.data);
            }
            this.digitalState.repaint();
        }
    }

    private static class DigitalAxisPanel
    extends AxisPanel {
        private static final long serialVersionUID = -4006900519933869168L;
        JLabel digitalState = new JLabel("<unread>");

        public DigitalAxisPanel(Component ax) {
            super(ax);
            this.add((java.awt.Component)this.digitalState, "Center");
        }

        @Override
        protected void renderData() {
            if (this.data == 0.0f) {
                this.digitalState.setBackground(this.getBackground());
                this.digitalState.setText("OFF");
            } else if (this.data == 1.0f) {
                this.digitalState.setBackground(Color.green);
                this.digitalState.setText("ON");
            } else {
                this.digitalState.setBackground(Color.red);
                this.digitalState.setText("ERR:" + this.data);
            }
            this.digitalState.repaint();
        }
    }

    private static abstract class AxisPanel
    extends JPanel {
        private static final long serialVersionUID = -2117191506803328790L;
        transient Component axis;
        float data;

        public AxisPanel(Component ax) {
            this.axis = ax;
            this.setLayout(new BorderLayout());
            this.add((java.awt.Component)new JLabel(ax.getName() + "(" + String.valueOf(ax.getIdentifier()) + ")"), "North");
        }

        public void poll() {
            this.data = this.axis.getPollData();
            this.renderData();
        }

        public Component getAxis() {
            return this.axis;
        }

        protected abstract void renderData();
    }
}

