/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.weblets.util;

import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.dev.weblets.WebletContainer;

class TextProcessingWriter
extends Writer {
    public static final Pattern _WEBLET_URL = Pattern.compile("weblet:\\s*url\\s*\\(\\s*[\"\\']([^\"\\']+)[\"\\']\\s*\\,\\s*[\"\\']([^\"\\'\\)]+)[\"\\']\\s*\\)?(.*)");
    public static final Pattern _WEBLET_RESOURCE = Pattern.compile("weblet:\\s*resource\\s*\\(\\s*[\"\\']([^\"\\'/]+)[\"\\']\\s*\\,\\s*[\"\\']([^\"\\'\\)]+)[\"\\']\\s*\\)?(.*)");
    Writer r;
    int read = 0;
    StringBuffer buf = new StringBuffer();
    String webletName;
    int offShift = 0;

    public TextProcessingWriter(Writer r, String webletName) {
        this.r = r;
        this.webletName = webletName;
    }

    public void write(char[] chars, int off, int len) throws IOException {
        if (chars == null) {
            throw new IOException("Null array");
        }
        String currentBuf = new String(chars).substring(off, len);
        int linePos = -1;
        int oldLinePos = 0;
        currentBuf = currentBuf.replaceAll("\r", "");
        while (linePos < currentBuf.length() - 1 && (linePos = currentBuf.substring(linePos + 1).indexOf(10)) != -1) {
            this.buf.append(currentBuf.substring(oldLinePos, linePos += oldLinePos));
            this.processLine(this.buf.toString());
            oldLinePos = linePos + 1;
            this.buf = new StringBuffer();
        }
        if (oldLinePos < currentBuf.length()) {
            this.buf.append(currentBuf.substring(oldLinePos));
        }
    }

    private void processLine(String line) throws IOException {
        int startWebletUrl = 0;
        if ((startWebletUrl = line.substring(startWebletUrl).indexOf("weblet:url(")) != -1) {
            String protocol = line.substring(startWebletUrl);
            Matcher matcher = _WEBLET_URL.matcher(protocol);
            this.resolveLine(line, startWebletUrl, matcher, true);
        } else {
            startWebletUrl = line.indexOf("weblet:resource(");
            if (startWebletUrl != -1) {
                String protocol = line.substring(startWebletUrl);
                Matcher matcher = _WEBLET_RESOURCE.matcher(protocol);
                this.resolveLine(line, startWebletUrl, matcher, false);
            } else {
                this.r.write(line);
                this.r.write("\n");
            }
        }
    }

    private void resolveLine(String line, int startAt, Matcher matcher, boolean url) throws IOException {
        if (matcher.matches()) {
            String preamble = line.substring(0, startAt);
            String webletName = matcher.group(1);
            webletName = webletName != null ? webletName.trim() : webletName;
            String pathInfo = matcher.group(2);
            pathInfo = pathInfo != null ? pathInfo.trim() : pathInfo;
            String postamble = matcher.group(3);
            if (webletName == null) {
                webletName = this.webletName;
            }
            WebletContainer container = WebletContainer.getInstance();
            String webletURL = null;
            webletURL = url ? container.getWebletContextPath() + container.getResourceUri(webletName, pathInfo) : container.getResourceUri(webletName, pathInfo);
            this.r.write(preamble);
            this.r.write(webletURL);
            this.r.write(postamble);
            this.r.write("\n");
        } else {
            this.r.write(line);
            this.r.write("\n");
        }
    }

    public void flush() throws IOException {
        this.r.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.r.write(this.buf.toString());
            this.r.flush();
        }
        finally {
            this.r.close();
        }
    }
}

