/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.weblets.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.dev.weblets.WebletContainer;

public class TextProcessingReader
extends BufferedReader {
    public static final Pattern _WEBLET_URL = Pattern.compile("weblet:\\s*url\\s*\\(\\s*[\"\\']([^\"\\']+)[\"\\']\\s*\\,\\s*[\"\\']([^\"\\'\\)]+)[\"\\']\\s*\\)?(.*)");
    public static final Pattern _WEBLET_RESOURCE = Pattern.compile("weblet:\\s*resource\\s*\\(\\s*[\"\\']([^\"\\'/]+)[\"\\']\\s*\\,\\s*[\"\\']([^\"\\'\\)]+)[\"\\']\\s*\\)?(.*)");
    BufferedReader r;
    StringBuffer processLineBuffer = new StringBuffer();
    StringBuffer readBuffer = null;
    String webletName;
    char[] lineBuf = new char[1];
    int linePos = -1;
    boolean done = false;

    public TextProcessingReader(Reader r, String webletName) {
        super(r);
        this.r = new BufferedReader(r);
        this.webletName = webletName;
    }

    public int read() throws IOException {
        if (this.linePos == this.lineBuf.length - 1) {
            this.linePos = -1;
        }
        if (this.linePos == -1) {
            String line = this.readLine();
            if (this.lineBuf == null) {
                return -1;
            }
            this.lineBuf = line.toCharArray();
            if (this.lineBuf.length == 0) {
                return -1;
            }
        }
        ++this.linePos;
        return this.lineBuf[this.linePos];
    }

    public int read(char[] chars, int i, int i1) throws IOException {
        char[] srcBuf = new char[i1 - i];
        int readChars = this.read(srcBuf);
        if (readChars == -1) {
            return -1;
        }
        System.arraycopy(srcBuf, 0, chars, i, readChars);
        return readChars;
    }

    public void reset() throws IOException {
        super.reset();
        this.done = false;
        this.readBuffer = null;
    }

    public int read(char[] chars) throws IOException {
        if (this.done) {
            return -1;
        }
        if (this.readBuffer == null) {
            this.readBuffer = new StringBuffer(128);
        }
        do {
            if (this.readBuffer.length() >= chars.length) continue;
            String line = this.readLine();
            if (line == null) {
                char[] srcArr = this.readBuffer.toString().toCharArray();
                System.arraycopy(srcArr, 0, chars, 0, srcArr.length);
                this.done = true;
                return srcArr.length;
            }
            this.readBuffer.append(line);
        } while (this.readBuffer.length() < chars.length);
        char[] srcArr = this.readBuffer.toString().toCharArray();
        System.arraycopy(srcArr, 0, chars, 0, chars.length);
        StringBuffer newReadBuffer = new StringBuffer(128);
        newReadBuffer.append(this.readBuffer.substring(chars.length));
        this.readBuffer = newReadBuffer;
        return chars.length;
    }

    public String readLine() throws IOException {
        String line = this.r.readLine();
        if (line == null) {
            return line;
        }
        line = this.processLine(line);
        return line;
    }

    private String processLine(String line) throws IOException {
        int startWebletUrl = 0;
        if ((startWebletUrl = line.substring(startWebletUrl).indexOf("weblet:url(")) != -1) {
            String protocol = line.substring(startWebletUrl);
            Matcher matcher = _WEBLET_URL.matcher(protocol);
            return this.resolveLine(line, startWebletUrl, matcher, true);
        }
        startWebletUrl = line.indexOf("weblet:resource(");
        if (startWebletUrl != -1) {
            String protocol = line.substring(startWebletUrl);
            Matcher matcher = _WEBLET_RESOURCE.matcher(protocol);
            return this.resolveLine(line, startWebletUrl, matcher, false);
        }
        return line + "\n";
    }

    private String resolveLine(String line, int startAt, Matcher matcher, boolean url) throws IOException {
        StringBuffer buf = new StringBuffer(line.length() + 64);
        if (matcher.matches()) {
            String preamble = line.substring(0, startAt);
            String webletName = matcher.group(1);
            webletName = webletName != null ? webletName.trim() : webletName;
            String pathInfo = matcher.group(2);
            pathInfo = pathInfo != null ? pathInfo.trim() : pathInfo;
            String postamble = matcher.group(3);
            if (webletName == null) {
                webletName = this.webletName;
            }
            WebletContainer container = WebletContainer.getInstance();
            String webletURL = null;
            webletURL = url ? container.getWebletContextPath() + container.getResourceUri(webletName, pathInfo) : container.getResourceUri(webletName, pathInfo);
            buf.append(preamble);
            buf.append(webletURL);
            buf.append(postamble);
            buf.append("\n");
        } else {
            buf.append(line);
            buf.append("\n");
        }
        return buf.toString();
    }

    public void close() throws IOException {
        this.r.close();
    }
}

