/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.weblets.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import net.java.dev.weblets.util.CopyStrategy;
import net.java.dev.weblets.util.ReaderInputStream;
import net.java.dev.weblets.util.TextProcessingReader;

public class CopyStrategyImpl
implements CopyStrategy {
    public void copy(String webletName, String contentType, InputStream in, OutputStream out) throws IOException {
        boolean isText = this.isText(contentType);
        if (isText) {
            this.copyText(webletName, new InputStreamReader(in), new OutputStreamWriter(out));
        } else {
            this.copyStream(in, out);
        }
    }

    private boolean isText(String contentType) {
        return contentType != null && (contentType.startsWith("text/") || contentType.endsWith("xml") || contentType.equals("application/x-javascript"));
    }

    public InputStream wrapInputStream(String webletName, String mimetype, InputStream in) throws IOException {
        if (this.isText(mimetype)) {
            BufferedReader bufIn = new BufferedReader(this.mapResponseReader(webletName, new InputStreamReader(in)));
            return new ReaderInputStream(bufIn);
        }
        return new BufferedInputStream(this.mapInputStream(in));
    }

    protected BufferedWriter mapResponseWriter(Writer out) {
        return new BufferedWriter(out);
    }

    protected BufferedReader mapResponseReader(String webletName, Reader in) {
        return new TextProcessingReader(in, webletName);
    }

    protected BufferedInputStream mapInputStream(InputStream in) {
        return new BufferedInputStream(in);
    }

    protected BufferedOutputStream mapOutputStream(OutputStream out) {
        return new BufferedOutputStream(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyText(String webletName, Reader in, Writer out) throws IOException {
        byte[] buffer = new byte[2048];
        boolean len = false;
        boolean total = false;
        BufferedReader bufIn = this.mapResponseReader(webletName, in);
        BufferedWriter bufOut = this.mapResponseWriter(out);
        try {
            String line = null;
            while ((line = bufIn.readLine()) != null) {
                bufOut.write(line);
                bufOut.write("\n");
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            bufIn.close();
            bufOut.close();
            throw throwable;
        }
        bufIn.close();
        bufOut.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[2048];
        BufferedInputStream bufIn = this.mapInputStream(in);
        BufferedOutputStream bufOut = this.mapOutputStream(out);
        int len = 0;
        int total = 0;
        try {
            while ((len = bufIn.read(buffer)) > 0) {
                bufOut.write(buffer, 0, len);
                total += len;
            }
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            bufIn.close();
            bufOut.close();
            throw throwable;
        }
        bufIn.close();
        bufOut.close();
    }
}

