/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.weblets.packaged;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.java.dev.weblets.WebletConfig;
import net.java.dev.weblets.WebletRequest;
import net.java.dev.weblets.WebletResponse;
import net.java.dev.weblets.util.CopyStrategy;
import net.java.dev.weblets.util.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebletResourceloadingUtils {
    static WebletResourceloadingUtils instance = new WebletResourceloadingUtils();
    private static final long MILLIS_PER_YEAR = 31536000000L;
    static final int CACHED_URLS = 3000;
    static final String CACHE_KEY = "WEBLET_CACHE";

    public URL getResourceUrl(WebletRequest request, String resourcePath) {
        Map urlCache = this.getResourceURLCache(request);
        URL url = null;
        url = (URL)urlCache.get(resourcePath);
        if (url != null) {
            return url;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        url = loader.getResource(resourcePath);
        if (url == null) {
            loader = this.getClass().getClassLoader();
            url = loader.getResource(resourcePath);
        }
        urlCache.put(resourcePath, url);
        return url;
    }

    public URL getResourceUrl(String resourcePath) {
        URL url = null;
        if (url != null) {
            return url;
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        url = loader.getResource(resourcePath);
        if (url == null) {
            loader = this.getClass().getClassLoader();
            url = loader.getResource(resourcePath);
        }
        return url;
    }

    private Map getResourceURLCache(WebletRequest request) {
        HttpSession session = ((HttpServletRequest)request.getExternalRequest()).getSession();
        Map cache = (Map)session.getAttribute(CACHE_KEY);
        if (cache == null) {
            cache = Collections.synchronizedMap(new HashMap(3000));
            session.setAttribute(CACHE_KEY, cache);
        }
        if (cache.size() >= 3000) {
            cache.clear();
        }
        return cache;
    }

    public static WebletResourceloadingUtils getInstance() {
        return instance;
    }

    public void loadFromUrl(WebletConfig config, WebletRequest request, WebletResponse response, URL url, CopyStrategy copyProvider) throws IOException {
        if (url != null) {
            URLConnection conn = url.openConnection();
            long lastmodified = conn.getLastModified();
            this.loadResourceFromStream(config, request, response, copyProvider, conn.getInputStream(), lastmodified);
        } else {
            response.setStatus(1);
        }
    }

    private void prepareVersionedResponse(WebletConfig config, WebletResponse response, long lastmodified, long timeout) {
        String webletVersion = config.getWebletVersion();
        if (!WebletResourceloadingUtils.isVersionedWeblet(webletVersion)) {
            response.setLastModified(lastmodified);
            response.setContentVersion(webletVersion == null ? "" : webletVersion, WebletResourceloadingUtils.getPast());
        } else {
            response.setLastModified(timeout);
            response.setContentVersion(webletVersion, timeout);
        }
    }

    private long getTimeout(WebletConfig config) {
        String cacheControlTimeout = config.getInitParameter("cachecontrol-timeout");
        long timeout = WebletResourceloadingUtils.getNever();
        if (!StringUtils.isBlank(cacheControlTimeout)) {
            try {
                timeout = Long.parseLong(cacheControlTimeout);
            }
            catch (RuntimeException ex) {
                Log log = LogFactory.getLog(this.getClass());
                log.error((Object)"Weblets: Cache control is set but to an invalid value setting now never instead");
            }
        }
        return timeout;
    }

    private long fixTimeValue(long browserTimeValue) {
        if (browserTimeValue > 1000L) {
            browserTimeValue -= browserTimeValue % 1000L;
        }
        return browserTimeValue;
    }

    public void loadResourceFromStream(WebletConfig config, WebletRequest request, WebletResponse response, CopyStrategy copyProvider, InputStream in, long resourceLastmodified) throws IOException {
        if (in != null) {
            long requestCacheState = request.getIfModifiedSince();
            requestCacheState = this.fixTimeValue(requestCacheState);
            long resourceModifiedState = resourceLastmodified;
            resourceModifiedState = this.fixTimeValue(resourceModifiedState);
            boolean load = false;
            long currentTime = System.currentTimeMillis();
            long currentUTCTime = currentTime - (long)TimeZone.getDefault().getOffset(currentTime);
            long utcResourceModifiedState = resourceModifiedState - (long)TimeZone.getDefault().getOffset(resourceModifiedState) + this.getTimeout(config);
            boolean bl = load = requestCacheState < utcResourceModifiedState || requestCacheState < currentUTCTime;
            if (load) {
                this.prepareVersionedResponse(config, response, resourceLastmodified, System.currentTimeMillis() + this.getTimeout(config));
                this.loadResourceFromStream(config, request, response, copyProvider, in);
            } else {
                this.prepareVersionedResponse(config, response, resourceLastmodified, request.getIfModifiedSince() + (long)TimeZone.getDefault().getOffset(request.getIfModifiedSince()));
                response.setStatus(2);
            }
        } else {
            response.setStatus(1);
        }
    }

    public void loadResourceFromStream(WebletConfig config, WebletRequest request, WebletResponse response, CopyStrategy copyProvider, InputStream in) throws IOException {
        OutputStream out = response.getOutputStream();
        String finalMimetype = config.getMimeType(request.getPathInfo());
        copyProvider.copy(request.getWebletName(), finalMimetype, in, out);
    }

    public static boolean isVersionedWeblet(String webletVersion) {
        return webletVersion != null && !webletVersion.trim().equals("") && !webletVersion.endsWith("-SNAPSHOT");
    }

    public static long getNever() {
        long now = System.currentTimeMillis();
        return now + 31536000000L;
    }

    public static long getPast() {
        long now = System.currentTimeMillis();
        return now - 31536000000L;
    }
}

