/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.weblets.packaged;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import net.java.dev.weblets.Weblet;
import net.java.dev.weblets.WebletConfig;
import net.java.dev.weblets.WebletException;
import net.java.dev.weblets.WebletRequest;
import net.java.dev.weblets.WebletResponse;
import net.java.dev.weblets.packaged.WebletResourceloadingUtils;
import net.java.dev.weblets.util.CopyStrategyImpl;
import net.java.dev.weblets.util.StringUtils;

public class WebappWeblet
extends Weblet {
    String _packageName = "";
    private String _resourceRoot;

    public void init(WebletConfig config) {
        super.init(config);
        this._packageName = config.getInitParameter("package");
        this._resourceRoot = config.getInitParameter("resourceRoot");
        if (StringUtils.isBlank(this._resourceRoot)) {
            this._resourceRoot = "/";
        }
        this._resourceRoot = this._resourceRoot.trim();
        if (!this._resourceRoot.startsWith("/") && !this._resourceRoot.startsWith("\\")) {
            this._resourceRoot = "/" + this._resourceRoot;
        }
        if (this._packageName == null && this._resourceRoot == null) {
            throw new WebletException("Missing either init parameter \"package\" or  or init parameter \"resourceRoot\" for  Weblet \"" + config.getWebletName() + "\"");
        }
        this._resourceRoot = this._packageName != null ? this._packageName.replace('.', '/') : this._resourceRoot;
    }

    public void service(WebletRequest request, WebletResponse response) throws IOException {
        String resourcePath = this._resourceRoot + request.getPathInfo();
        HttpServletRequest httpRequest = (HttpServletRequest)request.getExternalRequest();
        CopyStrategyImpl copyProvider = new CopyStrategyImpl();
        if (resourcePath.indexOf("WEB-INF/") != -1 || resourcePath.indexOf("WEB-INF\\") != -1) {
            return;
        }
        if (resourcePath.indexOf("META-INF/") != -1 || resourcePath.indexOf("META-INF\\") != -1) {
            return;
        }
        URL url = httpRequest.getSession().getServletContext().getResource("/" + resourcePath);
        WebletResourceloadingUtils.getInstance().loadFromUrl(this.getWebletConfig(), request, response, url, copyProvider);
    }

    public InputStream serviceStream(String pathInfo, String mimetype) throws IOException, WebletException {
        return null;
    }

    public void destroy() {
        this._resourceRoot = null;
        this._packageName = null;
        super.destroy();
    }
}

