/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.weblets.packaged;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import net.java.dev.weblets.Weblet;
import net.java.dev.weblets.WebletConfig;
import net.java.dev.weblets.WebletException;
import net.java.dev.weblets.WebletRequest;
import net.java.dev.weblets.WebletResponse;
import net.java.dev.weblets.packaged.WebletResourceloadingUtils;
import net.java.dev.weblets.util.CopyStrategyImpl;

public class PackagedWeblet
extends Weblet {
    private String _resourceRoot;

    public void init(WebletConfig config) {
        super.init(config);
        String packageName = config.getInitParameter("package");
        String resourceRoot = config.getInitParameter("resourceRoot");
        if (packageName == null && resourceRoot == null) {
            throw new WebletException("Missing either init parameter \"package\" or  or init parameter \"resourceRoot\" for  Weblet \"" + config.getWebletName() + "\"");
        }
        this._resourceRoot = packageName != null ? packageName.replace('.', '/') : resourceRoot;
    }

    public void service(WebletRequest request, WebletResponse response) throws IOException {
        String resourcePath = this._resourceRoot + request.getPathInfo();
        CopyStrategyImpl copyProvider = new CopyStrategyImpl();
        URL url = WebletResourceloadingUtils.getInstance().getResourceUrl(request, resourcePath);
        WebletResourceloadingUtils.getInstance().loadFromUrl(this.getWebletConfig(), request, response, url, copyProvider);
    }

    public InputStream serviceStream(String pathInfo, String mimetype) throws IOException, WebletException {
        String resourcePath = this._resourceRoot + pathInfo;
        CopyStrategyImpl copyProvider = new CopyStrategyImpl();
        URL url = WebletResourceloadingUtils.getInstance().getResourceUrl(resourcePath);
        if (url == null) {
            return null;
        }
        URLConnection conn = url.openConnection();
        long lastmodified = conn.getLastModified();
        if (mimetype == null) {
            mimetype = this.getWebletConfig().getMimeType(resourcePath);
        }
        return copyProvider.wrapInputStream(this.getWebletConfig().getWebletName(), mimetype, conn.getInputStream());
    }

    public void destroy() {
        this._resourceRoot = null;
        super.destroy();
    }
}

