/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.jaxrs.xml.elements;

import java.util.Collection;
import java.util.Collections;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import net.java.dev.webdav.jaxrs.ConstantsAdapter;
import net.java.dev.webdav.util.Utilities;

@XmlAccessorType(value=XmlAccessType.NONE)
@XmlRootElement(name="timeout")
@XmlJavaTypeAdapter(value=Adapter.class)
public final class TimeOut {
    private static final long INFINITE_VALUE = Long.MAX_VALUE;
    private static final String INFINITE_TOKEN = "Infinite";
    private static final String SECOND_TOKEN = "Second-%d";
    public static final TimeOut INFINITE = new TimeOut();
    private long timeType;

    @XmlValue
    private final String getTimeType() {
        return this.timeType == Long.MAX_VALUE ? INFINITE_TOKEN : String.format(SECOND_TOKEN, this.timeType);
    }

    private final void setTimeType(String timeType) {
        this.timeType = INFINITE_TOKEN.equals(timeType) ? Long.MAX_VALUE : Long.parseLong(timeType.substring(timeType.lastIndexOf(45) + 1));
    }

    private TimeOut() {
        this(Long.MAX_VALUE);
    }

    public TimeOut(long seconds) {
        this.timeType = seconds;
    }

    public final boolean isInfinite() {
        return this.timeType == Long.MAX_VALUE;
    }

    public final long getSeconds() {
        return this.timeType;
    }

    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TimeOut)) {
            return false;
        }
        TimeOut that = (TimeOut)object;
        return this.timeType == that.timeType;
    }

    public final int hashCode() {
        return Long.valueOf(this.timeType).hashCode();
    }

    public final String toString() {
        return Utilities.toString(this, this.timeType);
    }

    protected static final class Adapter
    extends ConstantsAdapter<TimeOut> {
        protected Adapter() {
        }

        @Override
        protected final Collection<TimeOut> getConstants() {
            return Collections.singleton(INFINITE);
        }
    }
}

