/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.jaxrs.xml.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.java.dev.webdav.jaxrs.NullArgumentException;
import net.java.dev.webdav.jaxrs.xml.elements.Error;
import net.java.dev.webdav.jaxrs.xml.elements.HRef;
import net.java.dev.webdav.jaxrs.xml.elements.Location;
import net.java.dev.webdav.jaxrs.xml.elements.PropStat;
import net.java.dev.webdav.jaxrs.xml.elements.ResponseDescription;
import net.java.dev.webdav.jaxrs.xml.elements.Status;
import net.java.dev.webdav.util.Utilities;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"hRefs", "status", "propStats", "error", "responseDescription", "location"})
@XmlRootElement
public final class Response {
    @XmlElement(name="href")
    private final List<HRef> hRefs;
    private final Status status;
    @XmlElement(name="propstat")
    private final List<PropStat> propStats;
    private final Error error;
    @XmlElement(name="responsedescription")
    private ResponseDescription responseDescription;
    private Location location;

    private Response() {
        this(new LinkedList<HRef>(), null, new LinkedList<PropStat>(), null, null, null);
    }

    private Response(List<HRef> hRefs, Status status, List<PropStat> propStats, Error error, ResponseDescription responseDescription, Location location) {
        this.hRefs = hRefs;
        this.status = status;
        this.propStats = propStats;
        this.error = error;
        this.responseDescription = responseDescription;
        this.location = location;
    }

    public Response(HRef hRef, Error error, ResponseDescription responseDescription, Location location, PropStat propStat, PropStat ... propStats) {
        this(Collections.singletonList(hRef), null, Utilities.append(Utilities.notNull(propStat, "propStat"), propStats), error, responseDescription, location);
    }

    @Deprecated
    public Response(HRef hRef, Error error, ResponseDescription responseDescription, Location location, Collection<PropStat> propStats) {
        this(Collections.singletonList(hRef), null, new ArrayList<PropStat>(Utilities.notNull(propStats, "propStats")), error, responseDescription, location);
        if (propStats.isEmpty()) {
            throw new NullArgumentException("propStat");
        }
    }

    public Response(Status status, Error error, ResponseDescription responseDescription, Location location, HRef hRef, HRef ... hRefs) {
        this(Utilities.append(Utilities.notNull(hRef, "hRef"), hRefs), Utilities.notNull(status, "status"), Collections.emptyList(), error, responseDescription, location);
    }

    public final List<HRef> getHRefs() {
        return Collections.unmodifiableList(this.hRefs);
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Error getError() {
        return this.error;
    }

    public final ResponseDescription getResponseDescription() {
        return this.responseDescription;
    }

    public final Location getLocation() {
        return this.location;
    }

    public final List<PropStat> getPropStats() {
        return Collections.unmodifiableList(this.propStats);
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response that = (Response)o;
        return Arrays.equals(Utilities.array(this.hRefs, this.status, this.propStats, this.error, this.responseDescription, this.location), Utilities.array(that.hRefs, that.status, that.propStats, that.error, that.responseDescription, that.location));
    }

    public final int hashCode() {
        return Objects.hash(this.hRefs, this.status, this.propStats, this.error, this.responseDescription, this.location);
    }

    public final String toString() {
        return Utilities.toString(this, this.status, this.propStats, this.error, this.responseDescription, this.location);
    }
}

