/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.core.jaxrs.xml.elements;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import net.java.dev.webdav.core.jaxrs.NullArgumentException;
import net.java.dev.webdav.core.jaxrs.xml.elements.Error;
import net.java.dev.webdav.core.jaxrs.xml.elements.HRef;
import net.java.dev.webdav.core.jaxrs.xml.elements.Location;
import net.java.dev.webdav.core.jaxrs.xml.elements.PropStat;
import net.java.dev.webdav.core.jaxrs.xml.elements.ResponseDescription;
import net.java.dev.webdav.core.jaxrs.xml.elements.Status;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(propOrder={"hRefs", "status", "propStats", "error", "responseDescription", "location"})
@XmlRootElement
public final class Response {
    @XmlElement(name="href")
    private LinkedList<HRef> hRefs;
    private Status status;
    @XmlElement(name="propstat")
    private LinkedList<PropStat> propStats;
    private Error error;
    @XmlElement(name="responsedescription")
    private ResponseDescription responseDescription;
    private Location location;

    private Response() {
    }

    private Response(HRef hRef, Error error, ResponseDescription responseDescription, Location location) {
        if (hRef == null) {
            throw new NullArgumentException("hRef");
        }
        this.hRefs = new LinkedList<HRef>(Collections.singletonList(hRef));
        this.error = error;
        this.responseDescription = responseDescription;
        this.location = location;
    }

    public Response(HRef hRef, Error error, ResponseDescription responseDescription, Location location, PropStat propStat, PropStat ... propStats) {
        this(hRef, error, responseDescription, location);
        if (propStat == null) {
            throw new NullArgumentException("propStat");
        }
        this.propStats = new LinkedList<PropStat>(Collections.singletonList(propStat));
        this.propStats.addAll(Arrays.asList(propStats));
    }

    public Response(Status status, Error error, ResponseDescription responseDescription, Location location, HRef hRef, HRef ... hRefs) {
        this(hRef, error, responseDescription, location);
        if (status == null) {
            throw new NullArgumentException("status");
        }
        this.status = status;
        this.hRefs.addAll(Arrays.asList(hRefs));
    }

    public final List<HRef> getHRefs() {
        return (List)this.hRefs.clone();
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Error getError() {
        return this.error;
    }

    public final ResponseDescription getResponseDescription() {
        return this.responseDescription;
    }

    public final Location getLocation() {
        return this.location;
    }

    public final List<PropStat> getPropStats() {
        return (List)this.propStats.clone();
    }
}

