/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.interop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.java.dev.webdav.interop.HttpMethod;
import net.java.dev.webdav.interop.HttpServletResponseWrapper;

public class WindowsRedirectorPatchResourceFilter
implements Filter {
    public static final String MS_AUTHOR_VIA = "MS-Author-Via";
    public static final String DAV = "DAV";
    public static final String ROOT_RESOURCE = "/";
    private static final Logger logger = Logger.getLogger(WindowsRedirectorPatchResourceFilter.class.getName());
    private ServletContext context;
    private String webdavClass;
    private Set<String> userAgents;
    private Templates templates;

    public void destroy() {
        this.templates = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        block20: {
            HttpServletResponse response;
            HttpServletRequest request;
            block21: {
                HttpMethod method;
                boolean enableHook;
                if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
                    chain.doFilter(servletRequest, servletResponse);
                    return;
                }
                logger.finer("doFilter(..) - called");
                request = (HttpServletRequest)servletRequest;
                response = (HttpServletResponse)servletResponse;
                String agent = request.getHeader("user-agent");
                logger.fine("doFilter(..) - user-agent: " + agent + " - method: " + request.getMethod() + " uri: " + request.getRequestURI());
                boolean bl = enableHook = agent != null && (agent.contains("MiniRedir") || this.userAgents.contains(agent));
                if (!enableHook) break block21;
                try {
                    method = HttpMethod.valueOf(request.getMethod().toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    method = HttpMethod.UNKOWN;
                }
                logger.fine("doFilter(..) - method: " + (Object)((Object)method) + " - original: " + request.getMethod());
                switch (method) {
                    case OPTIONS: {
                        logger.fine("doFilter(..) - OPTIONS");
                        String uri = request.getRequestURI();
                        boolean isRoot = uri.equals(ROOT_RESOURCE);
                        logger.fine("doFilter(..) - URI: " + uri + " isRoot? " + isRoot);
                        chain.doFilter((ServletRequest)request, (ServletResponse)response);
                        if (isRoot) {
                            logger.fine("doFilter(..) - procssing isRoot");
                            response.setStatus(200);
                            if (!response.containsHeader(DAV)) {
                                response.addHeader(DAV, this.webdavClass);
                            }
                        }
                        if (!response.containsHeader(MS_AUTHOR_VIA)) {
                            response.addHeader(MS_AUTHOR_VIA, DAV);
                            break;
                        }
                        break block20;
                    }
                    case LOCK: 
                    case PROPFIND: {
                        logger.fine("doFilter(..) - PROPFIND or LOCK");
                        HttpServletResponseWrapper responseWrapper = new HttpServletResponseWrapper(response);
                        logger.finest("doFilter(..) - delegating service request");
                        chain.doFilter((ServletRequest)request, (ServletResponse)responseWrapper);
                        logger.finest("doFilter(..) - get response back");
                        String responseMsg = responseWrapper.toString();
                        if (method == HttpMethod.LOCK && responseWrapper.getStatusCode() == 405) {
                            PrintWriter out = response.getWriter();
                            try {
                                out.print("<?xml version=\"1.0\"?><d:prop xmlns:d=\"DAV:\"><d:lockdiscovery><d:activelock><d:lockscope><d:shared/></d:lockscope><d:locktype><d:write/></d:locktype><d:depth>0</d:depth><d:timeout>Second-0</d:timeout><d:locktoken><d:href>opaquelocktoken:");
                                out.print(UUID.randomUUID());
                                out.print("</d:href></d:locktoken><d:lockroot><d:href>");
                                out.print(request.getRequestURI());
                                out.print("</d:href></d:lockroot></d:activelock></d:lockdiscovery></d:prop>");
                                response.setStatus(200);
                                break block20;
                            }
                            finally {
                                out.flush();
                                out.close();
                            }
                        }
                        if (responseMsg.length() > 0) {
                            StringReader sr = new StringReader(responseMsg);
                            StreamSource xmlSource = new StreamSource(sr);
                            PrintWriter out = response.getWriter();
                            try {
                                Transformer transformer = this.templates.newTransformer();
                                ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
                                StreamResult result = new StreamResult(baos);
                                transformer.transform(xmlSource, result);
                                String tranformedResponse = baos.toString();
                                response.setContentLength(tranformedResponse.length());
                                out.write(tranformedResponse);
                                break block20;
                            }
                            catch (Exception ex) {
                                this.context.log("Error while transforming the XML with XSLT.", (Throwable)ex);
                                out.write(responseMsg);
                                break block20;
                            }
                            finally {
                                out.flush();
                                out.close();
                            }
                        }
                        break block20;
                    }
                    default: {
                        logger.finest("doFilter(..) - delegating service request");
                        chain.doFilter((ServletRequest)request, (ServletResponse)response);
                        logger.finest("doFilter(..) - get response back");
                    }
                }
                break block20;
            }
            logger.finest("doFilter(..) - delegating service request");
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            logger.finest("doFilter(..) - get response back");
        }
    }

    public void init(FilterConfig config) throws ServletException {
        try {
            this.context = config.getServletContext();
            String param = config.getInitParameter("interop-xslt");
            if (param == null) {
                param = "xml/prefix.xsl";
            }
            this.templates = TransformerFactory.newInstance().newTemplates(new StreamSource(this.getClass().getClassLoader().getResourceAsStream(param)));
            param = config.getInitParameter("interop-webdav-class");
            if (param == null) {
                param = "1";
            }
            this.webdavClass = param;
            this.userAgents = new HashSet<String>(Arrays.asList("Microsoft Data Access Internet Publishing Provider Protocol", "Microsoft Data Access Internet Publishing Provider DAV", "Microsoft Data Access Internet Publishing Provider DAV 1.1", "Microsoft Data Access Internet Publishing Provider Protocol Discovery", "DavClnt"));
        }
        catch (TransformerConfigurationException e) {
            throw new ServletException((Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new ServletException((Throwable)e);
        }
    }
}

