/* Copyright 2008, 2009 Daniel MANZKE, Markus KARG
 *
 * This file is part of webdav-jaxrs.
 *
 * webdav-jaxrs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * webdav-jaxrs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with webdav-jaxrs.  If not, see <http://www.gnu.org/licenses/>.
 */
package net.java.dev.webdav.interop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

/**
 * This class wraps a real HttpServletResponse and wraps the methods which are
 * responsible for setting the status code. It also catchs the OutputStream so
 * it could not be closed and send to the client.
 * 
 * @author Daniel MANZKE
 * @author Markus KARG
 */
public class HttpServletResponseWrapper extends
		javax.servlet.http.HttpServletResponseWrapper {
	private ByteArrayOutputStream output;

	public HttpServletResponseWrapper(HttpServletResponse response) {
		super(response);
		output = new ByteArrayOutputStream();
	}

	public ServletOutputStream getOutputStream() {
		return new FilterServletStream(output);
	}

	public PrintWriter getWriter() {
		return new PrintWriter(getOutputStream(), true);
	}
	
	@Override
	public String toString() {
		return output.toString();
	}
	
	private int statusCode;
	
	/*
	 * Until this code is migrated to Servlet API 3.0 (where getStatusCode() is
	 * already implemented in javax.servlet.http.HttpServletResponseWrapper) we
	 * need to implemented this functionality on our own.
	 */
	public final int getStatusCode() {
		return this.statusCode;
	}

	@Override
	public final void sendError(final int statusCode, final String statusMessage) throws IOException {
		super.sendError(statusCode, statusMessage);
		this.statusCode = statusCode;
	}

	@Override
	public final void sendError(final int statusCode) throws IOException {
		super.sendError(statusCode);
		this.statusCode = statusCode;
	}

	@Override
	public final void setStatus(final int statusCode, final String statusMessage) {
		super.setStatus(statusCode, statusMessage);
		this.statusCode = statusCode;		
	}

	@Override
	public final void setStatus(final int statusCode) {
		super.setStatus(statusCode);
		this.statusCode = statusCode;
	}
	
}
