/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.interop;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.logging.Logger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.java.dev.webdav.interop.HttpMethod;
import net.java.dev.webdav.interop.HttpServletResponseWrapper;

public class WindowsRedirectorPatchResourceFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(WindowsRedirectorPatchResourceFilter.class.getName());
    private ServletContext context;
    private Templates templates;

    public void destroy() {
        this.templates = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        block12: {
            block13: {
                boolean isMini;
                if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
                    chain.doFilter(servletRequest, servletResponse);
                    return;
                }
                logger.finer("doFilter(..) - called");
                HttpServletRequest request = (HttpServletRequest)servletRequest;
                HttpServletResponse response = (HttpServletResponse)servletResponse;
                String agent = request.getHeader("user-agent");
                logger.fine("doFilter(..) - user-agent: " + agent);
                boolean bl = isMini = agent != null && agent.contains("MiniRedir");
                if (!isMini) break block13;
                HttpMethod method = HttpMethod.method(request.getMethod());
                logger.fine("doFilter(..) - method: " + (Object)((Object)method) + " - original: " + request.getMethod());
                switch (method) {
                    case OPTIONS: {
                        logger.fine("doFilter(..) - OPTIONS");
                        String uri = request.getRequestURI();
                        boolean isRoot = uri.equals("/");
                        logger.fine("doFilter(..) - URI: " + uri + " isRoot? " + isRoot);
                        if (isRoot) {
                            logger.fine("doFilter(..) - procssing isRoot");
                            response.setStatus(204);
                            response.setHeader("DAV", "1");
                        }
                        response.setHeader("MS-Author-Via", "DAV");
                        break;
                    }
                    case PROPFIND: {
                        logger.fine("doFilter(..) - PROPFIND");
                        HttpServletResponseWrapper responseWrapper = new HttpServletResponseWrapper(response);
                        logger.finest("doFilter(..) - delegating service request");
                        chain.doFilter(servletRequest, (ServletResponse)responseWrapper);
                        logger.finest("doFilter(..) - get response back");
                        String responseMsg = responseWrapper.toString();
                        if (responseMsg.length() > 0) {
                            StringReader sr = new StringReader(responseMsg);
                            StreamSource xmlSource = new StreamSource(sr);
                            PrintWriter out = response.getWriter();
                            try {
                                Transformer transformer = this.templates.newTransformer();
                                ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
                                StreamResult result = new StreamResult(baos);
                                transformer.transform(xmlSource, result);
                                String tranformedResponse = baos.toString();
                                response.setContentLength(tranformedResponse.length());
                                out.write(tranformedResponse);
                                break block12;
                            }
                            catch (Exception ex) {
                                this.context.log("Error while transforming the XML with XSLT.", (Throwable)ex);
                                out.write(responseMsg);
                                break block12;
                            }
                            finally {
                                out.flush();
                                out.close();
                            }
                        }
                        break block12;
                    }
                    default: {
                        logger.finest("doFilter(..) - delegating service request");
                        chain.doFilter(servletRequest, servletResponse);
                        logger.finest("doFilter(..) - get response back");
                    }
                }
                break block12;
            }
            logger.finest("doFilter(..) - delegating service request");
            chain.doFilter(servletRequest, servletResponse);
            logger.finest("doFilter(..) - get response back");
        }
    }

    public void init(FilterConfig config) throws ServletException {
        try {
            this.context = config.getServletContext();
            String param = config.getInitParameter("interop-xslt");
            if (param == null) {
                param = "xml/prefix.xsl";
            }
            this.templates = TransformerFactory.newInstance().newTemplates(new StreamSource(this.getClass().getClassLoader().getResourceAsStream(param)));
        }
        catch (TransformerConfigurationException e) {
            throw new ServletException((Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new ServletException((Throwable)e);
        }
    }
}

