/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.interop.grizzly;

import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;
import java.util.logging.Logger;
import net.java.dev.webdav.interop.HttpMethod;

public class WindowsRedirectorPatchResourceAdapter
implements Adapter {
    private Logger logger = Logger.getLogger(WindowsRedirectorPatchResourceAdapter.class.getName());
    private Adapter original;

    public WindowsRedirectorPatchResourceAdapter(Adapter original) {
        this.original = original;
    }

    public void afterService(Request request, Response response) throws Exception {
        this.logger.finer("after service(..) - called");
        this.original.afterService(request, response);
        this.logger.finer("after service(..) - processed");
    }

    public void service(Request request, Response response) throws Exception {
        boolean isMini;
        this.logger.finer("service(..) - called");
        String agent = request.getHeader("user-agent");
        this.logger.fine("doFilter(..) - user-agent: " + agent);
        this.logger.finest("service(..) - delegating service request");
        this.original.service(request, response);
        this.logger.finest("service(..) - get response back");
        boolean bl = isMini = agent != null && agent.contains("MiniRedir");
        if (isMini) {
            HttpMethod method = HttpMethod.method(request.method().toString());
            this.logger.fine("doFilter(..) - method: " + (Object)((Object)method));
            switch (method) {
                case OPTIONS: {
                    this.logger.fine("doFilter(..) - OPTIONS");
                    String uri = request.requestURI().toString();
                    boolean isRoot = uri.equals("/");
                    this.logger.fine("doFilter(..) - URI: " + uri + " isRoot? " + isRoot);
                    if (isRoot) {
                        this.logger.fine("doFilter(..) - procssing isRoot");
                        response.setStatus(204);
                        response.setHeader("DAV", "1");
                    }
                    response.setHeader("MS-Author-Via", "DAV");
                    break;
                }
                case PROPFIND: {
                    this.logger.fine("doFilter(..) - PROPFIND");
                    break;
                }
            }
        }
    }
}

