/* Copyright 2008, 2009 Daniel MANZKE
 *
 * This file is part of webdav-jaxrs.
 *
 * webdav-jaxrs is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * webdav-jaxrs is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with webdav-jaxrs.  If not, see <http://www.gnu.org/licenses/>.
 */
package net.java.dev.webdav.interop.grizzly;

import static javax.servlet.http.HttpServletResponse.SC_NO_CONTENT;

import java.util.logging.Logger;

import net.java.dev.webdav.interop.HttpMethod;

import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.Request;
import com.sun.grizzly.tcp.Response;

@SuppressWarnings("unchecked")
public class WindowsRedirectorPatchResourceAdapter implements Adapter {
	private Logger logger = Logger
			.getLogger(WindowsRedirectorPatchResourceAdapter.class.getName());
	private Adapter original;

	public WindowsRedirectorPatchResourceAdapter(Adapter original) {
		super();
		this.original = original;
	}

	@Override
	public void afterService(Request request, Response response)
			throws Exception {
		logger.finer("after service(..) - called");
		original.afterService(request, response);
		logger.finer("after service(..) - processed");
	}

	// DAV = 1
	// MS-Author-Via = DAV
	// 204 / No Content
	@Override
	public void service(Request request, Response response) throws Exception {
		logger.finer("service(..) - called");

		final String agent = request.getHeader("user-agent");
		logger.fine("doFilter(..) - user-agent: " + agent);
		
		logger.finest("service(..) - delegating service request");
		original.service(request, response);
		logger.finest("service(..) - get response back");

		final boolean isMini = agent != null && agent.contains("MiniRedir");
		if (isMini) {
			final HttpMethod method = HttpMethod.method(request.method()
					.toString());
			logger.fine("doFilter(..) - method: " + method);

			switch (method) {
			case OPTIONS:
				logger.fine("doFilter(..) - OPTIONS");

				final String uri = request.requestURI().toString();
				final boolean isRoot = uri.equals("/");
				logger
						.fine("doFilter(..) - URI: " + uri + " isRoot? "
								+ isRoot);
				if (isRoot) {
					logger.fine("doFilter(..) - procssing isRoot");
					// if root, options, MiniRedir
					// return noContent, "DAV" = "1", "MS-Author-Via" = "DAV"
					response.setStatus(SC_NO_CONTENT);
					response.setHeader("DAV", "1");
				}
				// if options, MiniRedir
				// return "MS-Author-Via" = "DAV"
				response.setHeader("MS-Author-Via", "DAV");
				break;

			case PROPFIND:
				logger.fine("doFilter(..) - PROPFIND");
				// Get response from servlet
				//TODO Find a way to catch the data of the service before it will be send to the client
				/*
				  
				StringReader sr = new StringReader(new String(responseWrapper
						.toString()));
				Source xmlSource = new StreamSource(sr);

				final PrintWriter out = response.getWriter();
				try {
					final Transformer transformer = this.templates
							.newTransformer();
					CharArrayWriter caw = new CharArrayWriter();
					StreamResult result = new StreamResult(caw);
					transformer.transform(xmlSource, result);
					response.setContentLength(caw.toString().length());
					out.write(caw.toString());
				} catch (Exception ex) {
					out.println(ex.toString());
					out.write(responseWrapper.toString());
				} finally {
					out.flush();
					out.close();
				}
				
				*/

				break;

			default: break;
			}
		} 
	}
}
