/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.addressbook;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public final class ReadableHttpRequestWrapper
extends HttpServletResponseWrapper {
    private int statusCode;
    private String statusMessage;
    private Map<String, Collection<String>> headers = new HashMap<String, Collection<String>>();

    public ReadableHttpRequestWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    public final void addDateHeader(String name, long date) {
        super.addDateHeader(name, date);
        String value = new Date(date).toString();
        if (this.containsHeader(name)) {
            this.headers.get(name).add(value);
        } else {
            this.headers.put(name, new LinkedList<String>(Collections.singleton(value)));
        }
    }

    public final void addHeader(String name, String value) {
        super.addHeader(name, value);
        if (this.headers.containsKey(name)) {
            this.headers.get(name).add(value);
        } else {
            this.headers.put(name, new LinkedList<String>(Collections.singleton(value)));
        }
    }

    public final void addIntHeader(String name, int integer) {
        super.addIntHeader(name, integer);
        String value = Integer.toString(integer);
        if (this.headers.containsKey(name)) {
            this.headers.get(name).add(value);
        } else {
            this.headers.put(name, new LinkedList<String>(Collections.singleton(value)));
        }
    }

    public final void setDateHeader(String name, long date) {
        super.setDateHeader(name, date);
        this.headers.put(name, new LinkedList<String>(Collections.singleton(new Date(date).toString())));
    }

    public final void setHeader(String name, String value) {
        super.setHeader(name, value);
        this.headers.put(name, new LinkedList<String>(Collections.singleton(value)));
    }

    public final void setIntHeader(String name, int value) {
        super.setIntHeader(name, value);
        this.headers.put(name, new LinkedList<String>(Collections.singleton(Integer.toString(value))));
    }

    public final void setStatus(int statusCode, String statusMessage) {
        super.setStatus(statusCode, statusMessage);
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
    }

    public final void setStatus(int statusCode) {
        super.setStatus(statusCode);
        this.statusCode = statusCode;
    }

    public final void sendError(int statusCode) throws IOException {
        super.sendError(statusCode);
        this.statusCode = statusCode;
    }

    public final void sendError(int statusCode, String statusMessage) throws IOException {
        super.sendError(statusCode, statusMessage);
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
    }

    public final String getStatusMessage() {
        return this.statusMessage;
    }

    public final int getStatusCode() {
        return this.statusCode;
    }

    public final Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public final Collection<String> getHeaders(String name) {
        return this.headers.get(name);
    }
}

