/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.addressbook;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.java.dev.webdav.addressbook.ReadableHttpRequestWrapper;

public final class LoggingFilter
implements Filter {
    public void init(FilterConfig config) throws ServletException {
    }

    public final void destroy() {
    }

    public final void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    private final void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.logHttpServletRequest(request);
        ReadableHttpRequestWrapper wrapper = new ReadableHttpRequestWrapper(response);
        chain.doFilter((ServletRequest)request, (ServletResponse)wrapper);
        this.logHttpServletResponse(wrapper);
    }

    private final void logHttpServletRequest(HttpServletRequest request) {
        System.out.print(String.format("%1$tF %1$tT --> %2$s %3$s", new Date(), request.getMethod(), request.getPathInfo()));
        for (String headerName : Collections.list(request.getHeaderNames())) {
            for (String headerValue : Collections.list(request.getHeaders(headerName))) {
                System.out.print(String.format(" %s=%s", headerName, headerValue));
            }
        }
        System.out.println();
    }

    private final void logHttpServletResponse(ReadableHttpRequestWrapper response) {
        System.out.print(String.format("%1$tF %1$tT <-- %2$d %3$s", new Date(), response.getStatusCode(), response.getStatusMessage()));
        for (String headerName : response.getHeaderNames()) {
            for (String headerValue : response.getHeaders(headerName)) {
                System.out.print(String.format(" %s=%s", headerName, headerValue));
            }
        }
        System.out.println();
    }
}

