/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.addressbook;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import net.java.dev.webdav.jaxrs.NullArgumentException;

@XmlRootElement(namespace="sample")
@Entity
@Table
@NamedQueries(value={@NamedQuery(name="ListContacts", query="SELECT c FROM Contact c"), @NamedQuery(name="FindContactByMatchCode", query="SELECT c FROM Contact c WHERE c.matchCode = ?1"), @NamedQuery(name="DeleteContactByMatchCode", query="DELETE FROM Contact c WHERE c.matchCode = ?1")})
public final class Contact {
    @Id
    @GeneratedValue
    private int id;
    @Column(nullable=false, unique=true)
    private String matchCode;
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creationDate;
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModified;
    private String firstName;
    private String lastName;
    private String eMail;

    private Contact() {
    }

    public Contact(String matchCode, String firstName, String lastName, String eMail) {
        if (matchCode == null) {
            throw new NullArgumentException("matchCode");
        }
        this.matchCode = matchCode;
        this.firstName = firstName;
        this.lastName = lastName;
        this.eMail = eMail;
        this.creationDate = new Date();
        this.lastModified = new Date();
    }

    public Contact(String matchCode, Contact source) {
        if (matchCode == null) {
            throw new NullArgumentException("matchCode");
        }
        if (source == null) {
            throw new NullArgumentException("source");
        }
        this.matchCode = matchCode;
        this.firstName = source.firstName;
        this.lastName = source.lastName;
        this.eMail = source.eMail;
        this.creationDate = source.creationDate;
        this.lastModified = source.lastModified;
    }

    @XmlTransient
    public final String getMatchCode() {
        return this.matchCode;
    }

    public final void setMatchCode(String matchCode) {
        this.matchCode = matchCode;
    }

    @XmlTransient
    public final Date getCreationDate() {
        return this.creationDate;
    }

    @XmlTransient
    public final Date getLastModified() {
        return this.lastModified;
    }

    public final void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    public final String getFirstName() {
        return this.firstName;
    }

    public final void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public final String getLastName() {
        return this.lastName;
    }

    public final void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public final String getEMail() {
        return this.eMail;
    }

    public final void setEMail(String eMail) {
        this.eMail = eMail;
    }

    public final void update(Contact source) {
        this.eMail = source.eMail;
        this.firstName = source.firstName;
        this.lastName = source.lastName;
        this.lastModified = new Date();
    }

    public final String toString() {
        return String.format("%d: %s, %s (%s)", this.id, this.lastName, this.firstName, this.eMail);
    }
}

