/*
 * Decompiled with CFR 0.152.
 */
package net.java.dev.webdav.addressbook;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.UUID;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.NoResultException;
import javax.persistence.Persistence;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Providers;
import net.java.dev.webdav.addressbook.Contact;
import net.java.dev.webdav.addressbook.NullOutputStream;
import net.java.dev.webdav.jaxrs.ResponseStatus;
import net.java.dev.webdav.jaxrs.methods.COPY;
import net.java.dev.webdav.jaxrs.methods.LOCK;
import net.java.dev.webdav.jaxrs.methods.MOVE;
import net.java.dev.webdav.jaxrs.methods.PROPFIND;
import net.java.dev.webdav.jaxrs.methods.PROPPATCH;
import net.java.dev.webdav.jaxrs.methods.UNLOCK;
import net.java.dev.webdav.jaxrs.xml.elements.ActiveLock;
import net.java.dev.webdav.jaxrs.xml.elements.Depth;
import net.java.dev.webdav.jaxrs.xml.elements.HRef;
import net.java.dev.webdav.jaxrs.xml.elements.LockInfo;
import net.java.dev.webdav.jaxrs.xml.elements.LockRoot;
import net.java.dev.webdav.jaxrs.xml.elements.LockToken;
import net.java.dev.webdav.jaxrs.xml.elements.MultiStatus;
import net.java.dev.webdav.jaxrs.xml.elements.Prop;
import net.java.dev.webdav.jaxrs.xml.elements.PropStat;
import net.java.dev.webdav.jaxrs.xml.elements.PropertyUpdate;
import net.java.dev.webdav.jaxrs.xml.elements.RemoveOrSet;
import net.java.dev.webdav.jaxrs.xml.elements.Status;
import net.java.dev.webdav.jaxrs.xml.elements.TimeOut;
import net.java.dev.webdav.jaxrs.xml.properties.CreationDate;
import net.java.dev.webdav.jaxrs.xml.properties.DisplayName;
import net.java.dev.webdav.jaxrs.xml.properties.GetContentLength;
import net.java.dev.webdav.jaxrs.xml.properties.GetContentType;
import net.java.dev.webdav.jaxrs.xml.properties.GetLastModified;
import net.java.dev.webdav.jaxrs.xml.properties.LockDiscovery;
import net.java.dev.webdav.jaxrs.xml.properties.ResourceType;

@Path(value="addressbook")
public final class AddressBook {
    private static final String ADDRESS_MIME = "application/address+xml";
    private static final MediaType ADDRESS_TYPE = MediaType.valueOf((String)"application/address+xml");
    private final EntityManagerFactory emf = Persistence.createEntityManagerFactory((String)"AddressBook");

    @OPTIONS
    public final Response options() {
        return Response.noContent().header("DAV", (Object)"1, 2").header("Allow", (Object)"GET,DELETE,MOVE,COPY,PROPFIND,OPTIONS,HEAD,PUT,PROPPATCH,LOCK,UNLOCK").build();
    }

    @PROPFIND
    public final Response propfind(@Context UriInfo uriInfo, @DefaultValue(value="infinity") @HeaderParam(value="Depth") String depth, @Context Providers providers) throws IOException {
        net.java.dev.webdav.jaxrs.xml.elements.Response folder = new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(uriInfo.getRequestUri()), null, null, null, new PropStat(new Prop(new Object[]{new DisplayName("My Collection"), new CreationDate(new Date()), new GetLastModified(new Date()), ResourceType.COLLECTION}), new Status((Response.StatusType)Response.Status.OK)), new PropStat[0]);
        if (depth.equals("0")) {
            return Response.status((Response.StatusType)ResponseStatus.MULTI_STATUS).entity((Object)new MultiStatus(new net.java.dev.webdav.jaxrs.xml.elements.Response[]{folder})).build();
        }
        LinkedList<net.java.dev.webdav.jaxrs.xml.elements.Response> responses = new LinkedList<net.java.dev.webdav.jaxrs.xml.elements.Response>(Collections.singletonList(folder));
        for (Contact c : this.em().createNamedQuery("ListContacts").getResultList()) {
            responses.add(AddressBook.buildResponse(c, uriInfo.getAbsolutePathBuilder().path(String.format("%s.adr", c.getMatchCode())).build(new Object[0]), providers));
        }
        return Response.status((Response.StatusType)ResponseStatus.MULTI_STATUS).entity((Object)new MultiStatus(responses.toArray(new net.java.dev.webdav.jaxrs.xml.elements.Response[0]))).build();
    }

    @PROPFIND
    @Path(value="{filename}.adr")
    public final Response propfind(@PathParam(value="filename") String matchCode, @Context UriInfo uriInfo, @Context Providers providers) throws IOException {
        Contact c = (Contact)this.em().createNamedQuery("FindContactByMatchCode").setParameter(1, (Object)matchCode).getSingleResult();
        return Response.status((Response.StatusType)ResponseStatus.MULTI_STATUS).entity((Object)new MultiStatus(new net.java.dev.webdav.jaxrs.xml.elements.Response[]{AddressBook.buildResponse(c, uriInfo.getAbsolutePathBuilder().build(new Object[0]), providers)})).build();
    }

    private static final net.java.dev.webdav.jaxrs.xml.elements.Response buildResponse(Contact c, URI path, Providers providers) throws IOException {
        NullOutputStream nullOutputStream = new NullOutputStream();
        providers.getMessageBodyWriter(Contact.class, Contact.class, new Annotation[0], ADDRESS_TYPE).writeTo((Object)c, Contact.class, Contact.class, new Annotation[0], ADDRESS_TYPE, null, (OutputStream)nullOutputStream);
        return new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(path), null, null, null, new PropStat(new Prop(new Object[]{new DisplayName(String.format("%s %s", c.getLastName(), c.getFirstName())), new CreationDate(c.getCreationDate()), new GetLastModified(c.getLastModified()), new GetContentLength((long)nullOutputStream.getSize()), new GetContentType(ADDRESS_MIME)}), new Status((Response.StatusType)Response.Status.OK)), new PropStat[0]);
    }

    @PROPPATCH
    @Path(value="{filename}.adr")
    public final Response proppatch(InputStream body, @Context Providers providers, @Context HttpHeaders httpHeaders, @Context UriInfo uriInfo) throws IOException {
        PropertyUpdate propertyUpdate = (PropertyUpdate)providers.getMessageBodyReader(PropertyUpdate.class, PropertyUpdate.class, new Annotation[0], MediaType.APPLICATION_XML_TYPE).readFrom(PropertyUpdate.class, PropertyUpdate.class, new Annotation[0], MediaType.APPLICATION_XML_TYPE, httpHeaders.getRequestHeaders(), body);
        System.out.println("PATCH PROPERTIES: " + propertyUpdate.list());
        LinkedList<PropStat> propstats = new LinkedList<PropStat>();
        for (RemoveOrSet removeOrSet : propertyUpdate.list()) {
            propstats.add(new PropStat(removeOrSet.getProp(), new Status((Response.StatusType)Response.Status.FORBIDDEN)));
        }
        return Response.status((Response.StatusType)ResponseStatus.MULTI_STATUS).entity((Object)new MultiStatus(new net.java.dev.webdav.jaxrs.xml.elements.Response[]{new net.java.dev.webdav.jaxrs.xml.elements.Response(new HRef(uriInfo.getRequestUri()), null, null, null, propstats)})).build();
    }

    @GET
    @Produces(value={"application/address+xml"})
    @Path(value="{filename}.adr")
    public final Contact get(@PathParam(value="filename") String matchCode) {
        return (Contact)this.em().createNamedQuery("FindContactByMatchCode").setParameter(1, (Object)matchCode).getSingleResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/address+xml"})
    @Path(value="{filename}.adr")
    public final Response put(InputStream entityStream, @Context UriInfo uriInfo, @PathParam(value="filename") String matchCode, @HeaderParam(value="Content-Length") long contentLength, @Context Providers providers, @Context HttpHeaders httpHeaders) throws IOException {
        Contact entity = contentLength == 0L ? new Contact(matchCode, null, null, null) : (Contact)providers.getMessageBodyReader(Contact.class, Contact.class, new Annotation[0], new MediaType("application", "address+xml")).readFrom(Contact.class, Contact.class, new Annotation[0], new MediaType("application", "address+xml"), httpHeaders.getRequestHeaders(), entityStream);
        EntityManager em = this.em();
        EntityTransaction t = em.getTransaction();
        t.begin();
        try {
            ((Contact)em.createNamedQuery("FindContactByMatchCode").setParameter(1, (Object)matchCode).getSingleResult()).update(entity);
            Response response = Response.noContent().build();
            return response;
        }
        catch (NoResultException e) {
            em.persist((Object)entity);
            Response response = Response.created((URI)uriInfo.getAbsolutePath()).build();
            return response;
        }
        finally {
            t.commit();
        }
    }

    @DELETE
    @Path(value="{filename}.adr")
    public final void delete(@PathParam(value="filename") String matchCode) {
        EntityManager em = this.em();
        EntityTransaction t = em.getTransaction();
        t.begin();
        em.createNamedQuery("DeleteContactByMatchCode").setParameter(1, (Object)matchCode).executeUpdate();
        t.commit();
    }

    @MOVE
    @Path(value="{filename}.adr")
    public final void move(@PathParam(value="filename") String sourceMatchCode, @HeaderParam(value="Destination") URI destination, @HeaderParam(value="Overwrite") String overwrite) {
        Contact target;
        Contact source;
        EntityManager em = this.em();
        EntityTransaction t = em.getTransaction();
        t.begin();
        try {
            source = (Contact)em.createNamedQuery("FindContactByMatchCode").setParameter(1, (Object)sourceMatchCode).getSingleResult();
        }
        catch (NoResultException e) {
            t.rollback();
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String[] destinationPathSegments = destination.getPath().split("/");
        String lastDestinationPathSegment = destinationPathSegments[destinationPathSegments.length - 1];
        if (!lastDestinationPathSegment.endsWith(".adr")) {
            t.rollback();
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        String destinationMatchCode = lastDestinationPathSegment.split("\\.")[0];
        try {
            target = (Contact)em.createNamedQuery("FindContactByMatchCode").setParameter(1, (Object)destinationMatchCode).getSingleResult();
        }
        catch (NoResultException e) {
            target = null;
        }
        if (target != null) {
            if (overwrite.equals("F")) {
                t.rollback();
                throw new WebApplicationException(Response.Status.PRECONDITION_FAILED);
            }
            em.remove((Object)target);
        }
        em.remove((Object)source);
        em.persist((Object)new Contact(destinationMatchCode, source));
        t.commit();
    }

    @COPY
    @Path(value="{filename}.adr")
    public final void copy(@PathParam(value="filename") String sourceMatchCode, @HeaderParam(value="Destination") URI destination, @HeaderParam(value="Overwrite") String overwrite) {
        Contact target;
        Contact source;
        EntityManager em = this.em();
        EntityTransaction t = em.getTransaction();
        t.begin();
        try {
            source = (Contact)em.createNamedQuery("FindContactByMatchCode").setParameter(1, (Object)sourceMatchCode).getSingleResult();
        }
        catch (NoResultException e) {
            t.rollback();
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        String[] destinationPathSegments = destination.getPath().split("/");
        String lastDestinationPathSegment = destinationPathSegments[destinationPathSegments.length - 1];
        if (!lastDestinationPathSegment.endsWith(".adr")) {
            t.rollback();
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        String destinationMatchCode = lastDestinationPathSegment.split("\\.")[0];
        try {
            target = (Contact)em.createNamedQuery("FindContactByMatchCode").setParameter(1, (Object)destinationMatchCode).getSingleResult();
        }
        catch (NoResultException e) {
            target = null;
        }
        if (target != null) {
            if (overwrite.equals("F")) {
                t.rollback();
                throw new WebApplicationException(Response.Status.PRECONDITION_FAILED);
            }
            em.remove((Object)target);
        }
        em.persist((Object)new Contact(destinationMatchCode, source));
        t.commit();
    }

    @LOCK
    @Path(value="{filename}.adr")
    public final Prop lock(LockInfo lockInfo, @Context UriInfo uriInfo) {
        return new Prop(new Object[]{new LockDiscovery(new ActiveLock[]{new ActiveLock(lockInfo.getLockScope(), lockInfo.getLockType(), Depth.ZERO, lockInfo.getOwner(), new TimeOut(3600L), new LockToken(new HRef("opaquelocktoken:" + UUID.randomUUID())), new LockRoot(new HRef(uriInfo.getAbsolutePath())))})});
    }

    @UNLOCK
    @Path(value="{filename}.adr")
    public final void unlock() {
    }

    private final EntityManager em() {
        return this.emf.createEntityManager();
    }
}

